/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.validation;

import com.google.inject.Inject;
import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.server.HTTPRequest;
import java.util.function.Predicate;
import org.primeframework.mvc.PrimeException;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.ValidationMethodConfiguration;
import org.primeframework.mvc.action.config.ActionConfiguration;
import org.primeframework.mvc.message.Message;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.message.MessageType;
import org.primeframework.mvc.message.scope.MessageScope;
import org.primeframework.mvc.parameter.el.ExpressionException;
import org.primeframework.mvc.util.ReflectionUtils;
import org.primeframework.mvc.validation.Validatable;
import org.primeframework.mvc.validation.ValidationException;
import org.primeframework.mvc.validation.ValidationProcessor;

public class DefaultValidationProcessor
implements ValidationProcessor {
    private static final Predicate<Message> ErrorOrWarningMessages = m -> m.getType() == MessageType.WARNING || m.getType() == MessageType.ERROR;
    private final MessageStore messageStore;
    private final HTTPRequest request;
    private final ActionInvocationStore store;

    @Inject
    public DefaultValidationProcessor(HTTPRequest request, ActionInvocationStore store, MessageStore messageStore) {
        this.request = request;
        this.store = store;
        this.messageStore = messageStore;
    }

    @Override
    public void validate() throws ValidationException {
        HTTPMethod method;
        ActionInvocation actionInvocation = this.store.getCurrent();
        Object action = actionInvocation.action;
        ActionConfiguration actionConfiguration = actionInvocation.configuration;
        if (action == null || actionInvocation.method.validation != null && !actionInvocation.method.validation.enabled()) {
            return;
        }
        ReflectionUtils.invokeAll(action, actionConfiguration.preValidationMethods);
        if (action instanceof Validatable) {
            ((Validatable)action).validate();
        }
        if (actionConfiguration.validationMethods.containsKey(method = this.request.getMethod())) {
            for (ValidationMethodConfiguration methodConfig : actionConfiguration.validationMethods.get(method)) {
                try {
                    ReflectionUtils.invoke(methodConfig.method, action, new Object[0]);
                }
                catch (ExpressionException e) {
                    throw new PrimeException("Unable to invoke @ValidationMethod on the class [" + String.valueOf(actionConfiguration.actionClass) + "]", e);
                }
            }
        }
        ReflectionUtils.invokeAll(action, actionConfiguration.postValidationMethods);
        if (this.messageStore.get(MessageScope.REQUEST).stream().anyMatch(ErrorOrWarningMessages)) {
            throw new ValidationException();
        }
    }
}

