/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.util;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryStringTools {
    public static Map<String, List<String>> parseQueryString(String query) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        try {
            String[] parts;
            for (String part : parts = query.split("&")) {
                String[] pieces = part.split("=", 2);
                String name = URLDecoder.decode(pieces[0], StandardCharsets.UTF_8);
                String value = pieces.length > 1 ? URLDecoder.decode(pieces[1], StandardCharsets.UTF_8) : "";
                parameters.computeIfAbsent(name, k -> new ArrayList()).add(value);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid query string [" + query + "]", e);
        }
        return parameters;
    }
}

