/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.el;

import java.lang.reflect.Method;
import org.primeframework.mvc.parameter.convert.ConversionException;
import org.primeframework.mvc.parameter.convert.ConverterProvider;
import org.primeframework.mvc.parameter.convert.GlobalConverter;
import org.primeframework.mvc.parameter.el.Expression;
import org.primeframework.mvc.parameter.el.MemberAccessor;
import org.primeframework.mvc.util.ReflectionUtils;

public class IndexedAccessor
extends MemberAccessor {
    String index;

    public IndexedAccessor(ConverterProvider converterProvider, MemberAccessor accessor, String index) {
        super(converterProvider, accessor, null);
        this.index = index;
    }

    @Override
    public Object get(Expression expression) {
        Method getter = this.propertyInfo.getMethods().get("get");
        if (getter.getParameterTypes().length == 0) {
            return ReflectionUtils.invoke(getter, this.object, new Object[0]);
        }
        Class<?> indexType = getter.getParameterTypes()[0];
        GlobalConverter converter = this.converterProvider.lookup(indexType);
        if (converter == null) {
            throw new ConversionException("Error while getting an indexed property in the expression [" + expression.getExpression() + "]. The indexed property uses a key of type [" + String.valueOf(indexType) + "] but there isn't a converter registered for that type");
        }
        Object indexObject = converter.convertFromStrings(indexType, null, null, this.index);
        return ReflectionUtils.invoke(getter, this.object, indexObject);
    }

    @Override
    public boolean isIndexed() {
        return false;
    }

    @Override
    public void set(String[] values, Expression expression) {
        this.set(this.convert(expression, this.field, values), expression);
    }

    @Override
    public void set(Object value, Expression expression) {
        Method setter = this.propertyInfo.getMethods().get("set");
        if (setter.getParameterTypes().length == 1) {
            ReflectionUtils.invoke(setter, this.object, value);
        } else {
            Class<?> indexType = setter.getParameterTypes()[0];
            GlobalConverter converter = this.converterProvider.lookup(indexType);
            if (converter == null) {
                throw new ConversionException("Error while setting an indexed property in the expression [" + expression.getExpression() + "]. The indexed property uses a key of type [" + String.valueOf(indexType) + "] but there isn't a converter registered for that type");
            }
            Object indexObject = converter.convertFromStrings(indexType, null, null, this.index);
            ReflectionUtils.invoke(setter, this.object, indexObject, value);
        }
    }
}

