/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action.result;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.primeframework.mvc.PrimeException;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.config.ActionConfiguration;
import org.primeframework.mvc.action.result.AbstractResult;
import org.primeframework.mvc.action.result.annotation.JSON;
import org.primeframework.mvc.content.json.JacksonActionConfiguration;
import org.primeframework.mvc.message.ErrorMessage;
import org.primeframework.mvc.message.ErrorMessages;
import org.primeframework.mvc.message.FieldMessage;
import org.primeframework.mvc.message.Message;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.message.MessageType;
import org.primeframework.mvc.message.scope.MessageScope;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;
import org.primeframework.mvc.util.ReflectionUtils;

public class JSONResult
extends AbstractResult<JSON> {
    private final ActionInvocationStore actionInvocationStore;
    private final MessageStore messageStore;
    private final ObjectMapper objectMapper;
    private final HTTPResponse response;

    @Inject
    public JSONResult(ExpressionEvaluator expressionEvaluator, ActionInvocationStore actionInvocationStore, MessageStore messageStore, ObjectMapper objectMapper, HTTPResponse response) {
        super(expressionEvaluator);
        this.messageStore = messageStore;
        this.response = response;
        this.actionInvocationStore = actionInvocationStore;
        this.objectMapper = objectMapper;
    }

    @Override
    public boolean execute(JSON json) throws IOException {
        ErrorMessages jacksonObject;
        ActionInvocation actionInvocation = this.actionInvocationStore.getCurrent();
        Object action = actionInvocation.action;
        if (action == null) {
            throw new PrimeException("There is no action class and somehow we got into the JSONResult code. Bad mojo!");
        }
        ActionConfiguration configuration = actionInvocation.configuration;
        if (configuration == null) {
            throw new PrimeException("The action [" + String.valueOf(action.getClass()) + "] has no configuration. This should be impossible!");
        }
        boolean prettyPrint = false;
        Class<Void> serializationView = Void.TYPE;
        JacksonActionConfiguration.JSONPropertyFilterConfig jsonPropertyFilterConfig = null;
        List<Message> errorMessages = this.messageStore.get(MessageScope.REQUEST).stream().filter(m -> m.getType() == MessageType.ERROR).collect(Collectors.toList());
        if (errorMessages.size() > 0) {
            jacksonObject = this.convertErrors(errorMessages);
        } else {
            JacksonActionConfiguration jacksonActionConfiguration = (JacksonActionConfiguration)configuration.additionalConfiguration.get(JacksonActionConfiguration.class);
            if (jacksonActionConfiguration == null || jacksonActionConfiguration.responseMember == null) {
                throw new PrimeException("The action [" + String.valueOf(action.getClass()) + "] is missing a field annotated with @JSONResponse. This is used to figure out what to send back in the response.");
            }
            serializationView = jacksonActionConfiguration.getSerializationView();
            jacksonObject = this.expressionEvaluator.getValue(jacksonActionConfiguration.responseMember.name, action);
            if (jacksonObject == null) {
                throw new PrimeException("The @JSONResponse field [" + jacksonActionConfiguration.responseMember.name + "] in the action [" + String.valueOf(action.getClass()) + "] is null. It cannot be null!");
            }
            prettyPrint = jacksonActionConfiguration.responseMember.annotation.prettyPrint();
            jsonPropertyFilterConfig = jacksonActionConfiguration.jsonPropertyFilterConfig;
        }
        this.response.setStatus(json.status());
        this.response.setContentType(json.contentType());
        this.addCacheControlHeader(json, this.response);
        if (this.isHeadRequest(actionInvocation)) {
            return true;
        }
        SimpleFilterProvider filterProvider = null;
        ObjectMapper mapper = this.objectMapper;
        if (jsonPropertyFilterConfig != null) {
            PropertyFilter propertyFilter = (PropertyFilter)ReflectionUtils.invoke(jsonPropertyFilterConfig.method, action, new Object[0]);
            filterProvider = new SimpleFilterProvider().addFilter(jsonPropertyFilterConfig.name, propertyFilter);
            if (jsonPropertyFilterConfig.mixinSource != null && jsonPropertyFilterConfig.mixinTarget != null) {
                mapper = mapper.copy().addMixIn(jsonPropertyFilterConfig.mixinTarget, jsonPropertyFilterConfig.mixinSource);
            }
        }
        this.writeValue(mapper, this.response.getOutputStream(), jacksonObject, serializationView, prettyPrint, (FilterProvider)filterProvider);
        return true;
    }

    @Override
    protected String getCacheControl(JSON result) {
        return result.cacheControl();
    }

    @Override
    protected boolean getDisableCacheControl(JSON result) {
        return result.disableCacheControl();
    }

    private ErrorMessages convertErrors(List<Message> messages) {
        ErrorMessages errorMessages = new ErrorMessages();
        for (Message message : messages) {
            if (message instanceof FieldMessage) {
                FieldMessage fieldMessage = (FieldMessage)message;
                errorMessages.addFieldError(fieldMessage.getField(), fieldMessage.getCode(), fieldMessage.toString(), fieldMessage.getData());
                continue;
            }
            errorMessages.generalErrors.add(new ErrorMessage(message.getCode(), message.toString(), message.getData()));
        }
        return errorMessages;
    }

    private ObjectWriter getPrettyWriter(ObjectMapper objectMapper, FilterProvider filterProvider) {
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();
        prettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)new DefaultIndenter());
        return objectMapper.writerWithDefaultPrettyPrinter().withFeatures(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT}).with(filterProvider).with((PrettyPrinter)prettyPrinter);
    }

    private void writeValue(ObjectMapper mapper, OutputStream os, Object jacksonObject, Class<?> serializationView, boolean prettyPrint, FilterProvider filterProvider) throws IOException {
        if (!prettyPrint && serializationView == Void.TYPE) {
            if (filterProvider != null) {
                mapper.writer(filterProvider).writeValue(os, jacksonObject);
            } else {
                mapper.writeValue(os, jacksonObject);
            }
            return;
        }
        if (prettyPrint && serializationView != Void.TYPE) {
            this.getPrettyWriter(mapper, filterProvider).with(filterProvider).withView(serializationView).writeValue(os, jacksonObject);
            return;
        }
        if (prettyPrint) {
            this.getPrettyWriter(mapper, filterProvider).writeValue(os, jacksonObject);
            return;
        }
        if (filterProvider != null) {
            mapper.writerWithView(serializationView).with(filterProvider).writeValue(os, jacksonObject);
        } else {
            mapper.writerWithView(serializationView).writeValue(os, jacksonObject);
        }
    }
}

