/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.test;

import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.ext.beans.BeansWrapperBuilder;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateNotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Set;
import org.primeframework.mvc.test.DetectionMap;

public final class BodyTools {
    private static final Configuration config;

    public static String processTemplate(Path path, Object ... objectArray) throws IOException {
        return BodyTools.processTemplateWithMap(path, BodyTools.toMap(objectArray));
    }

    public static String processTemplateForAssertion(Path path, Object ... objectArray) throws IOException {
        return BodyTools.processTemplateWithMap(path, BodyTools.toMap(objectArray));
    }

    public static String processTemplateWithMap(Path path, DetectionMap detectionMap) throws IOException {
        Template template;
        StringWriter stringWriter;
        block5: {
            stringWriter = new StringWriter();
            template = null;
            try {
                template = config.getTemplate(path.toAbsolutePath().toString());
            }
            catch (TemplateNotFoundException templateNotFoundException) {
                if (!Files.notExists(path.toAbsolutePath(), new LinkOption[0])) break block5;
                Files.writeString(path.toAbsolutePath(), (CharSequence)"{\"prime-mvc-auto-generated\": true}", StandardOpenOption.SYNC, StandardOpenOption.DSYNC, StandardOpenOption.CREATE_NEW);
                config.clearTemplateCache();
                template = config.getTemplate(path.toAbsolutePath().toString());
            }
        }
        try {
            template.process((Object)detectionMap, (Writer)stringWriter);
            Set<Object> set = detectionMap.getUnusedVariables("_", "actual");
            if (!set.isEmpty()) {
                throw new IllegalArgumentException("Unused values %s found in the [%s] template. If it's acceptable for the variable to be unused, wrap it in an Optional".formatted(set.stream().sorted().toList(), path));
            }
            return stringWriter.toString();
        }
        catch (TemplateException templateException) {
            throw new RuntimeException(templateException);
        }
    }

    private static DetectionMap toMap(Object ... objectArray) {
        if (objectArray.length % 2 != 0) {
            String string = objectArray[objectArray.length - 1].toString();
            throw new IllegalArgumentException("Invalid mapping values. Must have a multiple of 2. Missing value for key [" + string + "]");
        }
        DetectionMap detectionMap = new DetectionMap();
        for (int i = 0; i < objectArray.length; i += 2) {
            detectionMap.put(objectArray[i].toString(), objectArray[i + 1]);
        }
        return detectionMap;
    }

    static {
        BeansWrapperBuilder beansWrapperBuilder = new BeansWrapperBuilder(Configuration.VERSION_2_3_32);
        beansWrapperBuilder.setExposeFields(true);
        beansWrapperBuilder.setSimpleMapWrapper(true);
        config = new Configuration(Configuration.VERSION_2_3_32);
        config.setDefaultEncoding("UTF-8");
        config.setNumberFormat("computer");
        config.setTagSyntax(2);
        config.setObjectWrapper((ObjectWrapper)beansWrapperBuilder.build());
        config.setNumberFormat("computer");
        try {
            config.setTemplateLoader((TemplateLoader)new FileTemplateLoader(new File("/")));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

