/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action.result;

import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.server.HTTPResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.easymock.EasyMock;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.ExecuteMethodConfiguration;
import org.primeframework.mvc.action.result.StreamResult;
import org.primeframework.mvc.action.result.annotation.Stream;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class StreamResultTest
extends PrimeBaseTest {
    @Test(dataProvider="httpMethod")
    public void explicit(HTTPMethod hTTPMethod, String string, String string2, String string3) throws IOException {
        Object object = new Object();
        ZonedDateTime zonedDateTime = ZonedDateTime.of(2021, 7, 4, 12, 42, 42, 0, ZoneOffset.UTC);
        ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)EasyMock.createStrictMock(ExpressionEvaluator.class);
        EasyMock.expect((Object)expressionEvaluator.expand("10", object, false)).andReturn((Object)"10");
        EasyMock.expect((Object)expressionEvaluator.expand(string, object, false)).andReturn((Object)string);
        EasyMock.expect((Object)expressionEvaluator.expand("application/octet-stream", object, false)).andReturn((Object)"application/octet-stream");
        EasyMock.expect((Object)expressionEvaluator.getValue("lastModified", object)).andReturn((Object)zonedDateTime);
        EasyMock.expect((Object)expressionEvaluator.getValue("stream", object)).andReturn((Object)new ByteArrayInputStream("test".getBytes()));
        EasyMock.replay((Object[])new Object[]{expressionEvaluator});
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        HTTPResponse hTTPResponse = new HTTPResponse(this){

            public OutputStream getOutputStream() {
                return byteArrayOutputStream;
            }
        };
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(object, new ExecuteMethodConfiguration(hTTPMethod, null, null), "/foo", "", null));
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        StreamImpl streamImpl = new StreamImpl("success", string, "10", "application/octet-stream", "stream", "lastModified");
        StreamResult streamResult = new StreamResult(expressionEvaluator, hTTPResponse, actionInvocationStore);
        streamResult.execute((Stream)streamImpl);
        if (hTTPMethod == HTTPMethod.GET) {
            Assert.assertEquals((String)byteArrayOutputStream.toString(), (String)"test");
            EasyMock.verify((Object[])new Object[]{expressionEvaluator});
            Assert.assertEquals((int)hTTPResponse.getStatus(), (int)200);
            Assert.assertEquals((String)hTTPResponse.getContentType(), (String)"application/octet-stream");
            Assert.assertEquals((long)hTTPResponse.getContentLength(), (long)10L);
            Assert.assertEquals((String)hTTPResponse.getHeader("Content-Disposition"), (String)("attachment; filename=\"" + string2 + "\"; filename*=UTF-8''" + string3));
            Assert.assertEquals((String)hTTPResponse.getHeader("Cache-Control"), (String)"no-cache");
            Assert.assertEquals((String)hTTPResponse.getHeader("Last-Modified"), (String)"Sun, 04 Jul 2021 12:42:42 GMT");
        } else {
            Assert.assertEquals((String)hTTPResponse.getOutputStream().toString(), (String)"");
        }
    }

    @DataProvider(name="httpMethod")
    public Object[][] httpMethod() {
        return new Object[][]{{HTTPMethod.GET, "foo.zip", "foo.zip", "foo.zip"}, {HTTPMethod.GET, "foo \\bar.zip", "foo \\\\bar.zip", "foo%20%5Cbar.zip"}, {HTTPMethod.GET, "foo bar.zip", "foo bar.zip", "foo%20bar.zip"}, {HTTPMethod.GET, "foo \"bar\" baz.zip", "foo \\\"bar\\\" baz.zip", "foo%20%22bar%22%20baz.zip"}, {HTTPMethod.GET, "foo \ud83d\ude00 baz.zip", "foo \ud83d\ude00 baz.zip", "foo%20%F0%9F%98%80%20baz.zip"}, {HTTPMethod.HEAD, "foo.zip", "foo.zip", "foo.zip"}, {HTTPMethod.HEAD, "foo \\bar.zip", "foo \\\\bar.zip", "foo%20%5Cbar.zip"}, {HTTPMethod.HEAD, "foo bar.zip", "foo bar.zip", "foo%20bar.zip"}, {HTTPMethod.HEAD, "foo \"bar\" baz.zip", "foo \\\"bar\\\" baz.zip", "foo%20%22bar%22%20baz.zip"}, {HTTPMethod.HEAD, "foo \ud83d\ude00 baz.zip", "foo \ud83d\ude00 baz.zip", "foo%20%F0%9F%98%80%20baz.zip"}};
    }

    public static class StreamImpl
    implements Stream {
        private final String cacheControl;
        private final String code;
        private final boolean disableCacheControl;
        private final String lastModifiedProperty;
        private final String length;
        private final String name;
        private final String property;
        private final int status = 200;
        private final String type;

        public StreamImpl(String string, String string2, String string3, String string4, String string5, String string6) {
            this.cacheControl = "no-cache";
            this.code = string;
            this.disableCacheControl = false;
            this.lastModifiedProperty = string6;
            this.length = string3;
            this.name = string2;
            this.property = string5;
            this.type = string4;
        }

        public Class<? extends Annotation> annotationType() {
            return Stream.class;
        }

        public String cacheControl() {
            return this.cacheControl;
        }

        public String code() {
            return this.code;
        }

        public boolean disableCacheControl() {
            return this.disableCacheControl;
        }

        public String lastModifiedProperty() {
            return this.lastModifiedProperty;
        }

        public String length() {
            return this.length;
        }

        public String name() {
            return this.name;
        }

        public String property() {
            return this.property;
        }

        public int status() {
            return 200;
        }

        public String type() {
            return this.type;
        }
    }
}

