/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc;

import com.google.inject.Inject;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.security.CBCCipherProvider;
import org.primeframework.mvc.security.CipherProvider;
import org.primeframework.mvc.security.DefaultEncryptor;
import org.primeframework.mvc.security.Encryptor;
import org.primeframework.mvc.util.CookieTools;
import org.testng.annotations.Test;

public class ManagedCookieTest
extends PrimeBaseTest {
    @Inject
    private Encryptor encryptor;

    @Test
    public void broken_csrf_case() throws Exception {
        String string = "NQryyR_pFrynPybHfMk_4Hka_J0HZ1WV6iVVWVki0mVg-WpdVkk2HO8_XQ46yhw8_w==";
        simulator.test("/managed-cookie").withCookie("cookie", string).get().assertBody("5").assertCookie("cookie", CookieTools.toCookie((byte[])"5".getBytes(), (boolean)false, (boolean)false, (Encryptor)this.encryptor));
        simulator.test("/managed-cookie").get().assertBody("5").assertCookie("cookie", CookieTools.toCookie((byte[])"5".getBytes(), (boolean)false, (boolean)false, (Encryptor)this.encryptor));
        simulator.test("/managed-cookie").withParameter("value", string).post().assertBody(string).assertCookie("cookie", CookieTools.toCookie((byte[])string.getBytes(), (boolean)false, (boolean)false, (Encryptor)this.encryptor));
        simulator.test("/managed-cookie").get().assertBody(string).assertCookie("cookie", CookieTools.toCookie((byte[])string.getBytes(), (boolean)false, (boolean)false, (Encryptor)this.encryptor));
    }

    @Test
    public void compressed_annotation_legacy_uncompressed_cookie_longer_than_5() throws Exception {
        String string = "foobar";
        byte[] byArray = this.objectMapper.writeValueAsBytes((Object)string);
        String string2 = Base64.getEncoder().encodeToString(byArray);
        String string3 = CookieTools.toCookie((byte[])string.getBytes(), (boolean)true, (boolean)false, (Encryptor)this.encryptor);
        this.test.simulate(() -> simulator.test("/compressed-managed-cookie").withCookie("cookie", string2).get().assertStatusCode(200).assertBody(string).assertCookie("cookie", string3)).simulate(() -> simulator.test("/compressed-managed-cookie").get().assertStatusCode(200).assertBody(string).assertCookie("cookie", string3));
    }

    @Test
    public void compressed_annotation_legacy_uncompressed_cookie_shorter_than_5() throws Exception {
        String string = "f";
        byte[] byArray = this.objectMapper.writeValueAsBytes((Object)string);
        String string2 = Base64.getEncoder().encodeToString(byArray);
        String string3 = CookieTools.toCookie((byte[])string.getBytes(), (boolean)true, (boolean)false, (Encryptor)this.encryptor);
        this.test.simulate(() -> simulator.test("/compressed-managed-cookie").withCookie("cookie", string2).get().assertStatusCode(200).assertBody(string).assertCookie("cookie", string3)).simulate(() -> simulator.test("/compressed-managed-cookie").get().assertStatusCode(200).assertBody(string).assertCookie("cookie", string3));
    }

    @Test
    public void compressed_only_cookie() throws Exception {
        this.test.simulate(() -> simulator.test("/compressed-managed-cookie").withParameter("value", "bar").post().assertStatusCode(200).assertBody("bar").assertCookie("cookie", CookieTools.toCookie((byte[])"bar".getBytes(), (boolean)true, (boolean)false, (Encryptor)this.encryptor))).simulate(() -> simulator.test("/compressed-managed-cookie").get().assertStatusCode(200).assertBody("bar").assertCookie("cookie", CookieTools.toCookie((byte[])"bar".getBytes(), (boolean)true, (boolean)false, (Encryptor)this.encryptor))).simulate(() -> simulator.test("/encrypted-managed-cookie").get().assertStatusCode(200).assertNormalizedBody("(null)").assertCookieWasDeleted("cookie")).simulate(() -> simulator.test("/compressed-managed-cookie").get().assertStatusCode(200).assertBody("(null)").assertDoesNotContainsCookie("cookie"));
    }

    @Test
    public void cookie_accidentally_starts_with_header() throws Exception {
        String string = "QkJCAEJC";
        this.test.simulate(() -> simulator.test("/managed-cookie").withCookie("cookie", string).get().assertStatusCode(200).assertBody("BB").assertCookie("cookie", string)).simulate(() -> simulator.test("/managed-cookie").get().assertStatusCode(200).assertBody("BB").assertCookie("cookie", string));
    }

    @Test
    public void cookie_is_base64_encoded_without_header() throws Exception {
        String string = Base64.getEncoder().encodeToString("foobar".getBytes());
        this.test.simulate(() -> simulator.test("/managed-cookie").withCookie("cookie", string).get().assertStatusCode(200).assertBody(string).assertCookie("cookie", CookieTools.toCookie((byte[])string.getBytes(), (boolean)false, (boolean)false, (Encryptor)this.encryptor)));
        this.test.simulate(() -> simulator.test("/managed-cookie").get().assertStatusCode(200).assertBody(string).assertCookie("cookie", CookieTools.toCookie((byte[])string.getBytes(), (boolean)false, (boolean)false, (Encryptor)this.encryptor)));
    }

    @Test
    public void legacy_cookie() throws Exception {
        String string = "foo";
        byte[] byArray = this.objectMapper.writeValueAsBytes((Object)string);
        DefaultEncryptor defaultEncryptor = new DefaultEncryptor((CipherProvider)new CBCCipherProvider((MVCConfiguration)configuration), (CipherProvider)new CBCCipherProvider((MVCConfiguration)configuration));
        byte[] byArray2 = defaultEncryptor.encrypt(byArray);
        String string2 = Base64.getUrlEncoder().encodeToString(byArray2);
        this.test.simulate(() -> simulator.test("/encrypted-managed-cookie").withCookie("cookie", string2).get().assertStatusCode(200).assertNormalizedBody("foo").assertEncryptedCookie("cookie", "foo")).simulate(() -> simulator.test("/encrypted-managed-cookie").withParameter("value", "bar").post().assertStatusCode(200).assertNormalizedBody("bar").assertEncryptedCookie("cookie", "bar")).simulate(() -> simulator.test("/encrypted-managed-cookie").get().assertStatusCode(200).assertNormalizedBody("bar"));
    }

    @Test
    public void managed_cookie_scope() throws Exception {
        String string = CookieTools.toCookie((byte[])"foo".getBytes(), (boolean)false, (boolean)false, (Encryptor)this.encryptor);
        String string2 = CookieTools.toCookie((byte[])"bar".getBytes(), (boolean)false, (boolean)false, (Encryptor)this.encryptor);
        String string3 = CookieTools.toCookie((byte[])"baz".getBytes(), (boolean)false, (boolean)false, (Encryptor)this.encryptor);
        this.test.simulate(() -> simulator.test("/managed-cookie-scopes").get().assertStatusCode(200).assertDoesNotContainsCookie("cookie1").assertDoesNotContainsCookie("cookie2").assertDoesNotContainsCookie("cookie3").assertDoesNotContainsCookie("fusionauth.sso")).simulate(() -> simulator.test("/managed-cookie-scopes").withURLParameter("writeCookie1", "foo").withURLParameter("writeCookie2", "bar").withURLParameter("writeCookie3", "baz").get().assertStatusCode(200).assertCookie("cookie1", string).assertCookie("cookie2", string2).assertCookie("fusionauth.sso", string3)).simulate(() -> simulator.test("/managed-cookie-scopes").get().assertStatusCode(200).assertCookie("cookie1", string).assertCookie("cookie2", string2).assertCookie("fusionauth.sso", string3)).simulate(() -> simulator.test("/managed-cookie-scopes").withURLParameter("deleteCookie2", true).get().assertStatusCode(200).assertCookie("cookie1", string).assertCookieWasDeleted("cookie2").assertCookie("fusionauth.sso", string3)).simulate(() -> simulator.test("/managed-cookie-scopes").get().assertStatusCode(200).assertCookie("cookie1", string).assertDoesNotContainsCookie("cookie2").assertCookie("fusionauth.sso", string3)).simulate(() -> simulator.test("/managed-cookie-scopes").get().assertStatusCode(200).assertCookie("cookie1", string).assertDoesNotContainsCookie("cookie2").assertCookie("fusionauth.sso", string3)).simulate(() -> simulator.test("/managed-cookie-scopes").withURLParameter("deleteCookie1", true).withURLParameter("deleteCookie3", true).get().assertStatusCode(200).assertCookieWasDeleted("cookie1").assertDoesNotContainsCookie("cookie2").assertCookieWasDeleted("fusionauth.sso")).simulate(() -> simulator.test("/managed-cookie-scopes").get().assertStatusCode(200).assertDoesNotContainsCookie("cookie1").assertDoesNotContainsCookie("cookie2").assertDoesNotContainsCookie("fusionauth.sso"));
    }

    @Test
    public void uncompressed_unencrypted_contains_json() throws Exception {
        String string = "foo";
        byte[] byArray = this.objectMapper.writeValueAsBytes((Object)string);
        String string2 = new String(byArray, StandardCharsets.UTF_8);
        this.test.simulate(() -> simulator.test("/managed-cookie").withCookie("cookie", string2).get().assertStatusCode(200).assertBody(string2).assertCookie("cookie", CookieTools.toCookie((byte[])byArray, (boolean)false, (boolean)false, (Encryptor)this.encryptor)));
        this.test.simulate(() -> simulator.test("/managed-cookie").get().assertStatusCode(200).assertBody(string2).assertCookie("cookie", CookieTools.toCookie((byte[])byArray, (boolean)false, (boolean)false, (Encryptor)this.encryptor)));
    }
}

