/*
 * Decompiled with CFR 0.152.
 */
package org.example.action.oauth;

import com.google.inject.Inject;
import io.fusionauth.jwt.JWTEncoder;
import io.fusionauth.jwt.Signer;
import io.fusionauth.jwt.domain.JWT;
import io.fusionauth.jwt.hmac.HMACSigner;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.UUID;
import org.example.domain.User;
import org.primeframework.mvc.action.annotation.Action;
import org.primeframework.mvc.action.result.annotation.Status;
import org.primeframework.mvc.security.MockOAuthUserLoginSecurityContext;
import org.primeframework.mvc.security.UserLoginSecurityContext;
import org.primeframework.mvc.security.oauth.Tokens;

@Action
@Status.List(value={@Status, @Status(code="unauthenticated", status=401)})
public class LoginAction {
    public static final String Subject = UUID.randomUUID().toString();
    private final UserLoginSecurityContext context;
    public boolean expired;

    @Inject
    public LoginAction(UserLoginSecurityContext userLoginSecurityContext) {
        this.context = userLoginSecurityContext;
    }

    public String post() {
        JWT jWT = new JWT();
        jWT.audience = "prime-tests";
        jWT.issuedAt = ZonedDateTime.now(ZoneOffset.UTC);
        jWT.expiration = this.expired ? jWT.issuedAt.minusMinutes(1L) : jWT.issuedAt.plusMinutes(1L);
        jWT.issuer = "Prime";
        jWT.subject = Subject;
        String string = new JWTEncoder().encode(jWT, (Signer)HMACSigner.newSHA256Signer((String)"secret"));
        this.context.login((Object)new Tokens(string, "prime-refresh-token-value"));
        User user = new User();
        user.setName("Brian Pontarelli");
        MockOAuthUserLoginSecurityContext.CurrentUser = user;
        return "success";
    }
}

