/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.workflow;

import org.easymock.EasyMock;
import org.primeframework.mvc.ErrorException;
import org.primeframework.mvc.MockConfiguration;
import org.primeframework.mvc.action.result.ResultStore;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.message.Message;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.message.SimpleMessage;
import org.primeframework.mvc.message.l10n.MessageProvider;
import org.primeframework.mvc.message.l10n.MissingMessageException;
import org.primeframework.mvc.validation.ValidationException;
import org.primeframework.mvc.workflow.ErrorExceptionHandler;
import org.testng.annotations.Test;

public class ErrorExceptionHandlerTest {
    @Test
    public void errorExceptionWithCustomResultCode() {
        MockErrorExceptionWithCode mockErrorExceptionWithCode = new MockErrorExceptionWithCode();
        MockConfiguration mockConfiguration = new MockConfiguration();
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        EasyMock.expect((Object)messageProvider.getMessage("[" + ((Object)((Object)mockErrorExceptionWithCode)).getClass().getSimpleName() + "]", mockErrorExceptionWithCode.args)).andReturn((Object)"foo");
        EasyMock.replay((Object[])new Object[]{messageProvider});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        messageStore.add((Message)EasyMock.isA(SimpleMessage.class));
        EasyMock.replay((Object[])new Object[]{messageStore});
        ResultStore resultStore = (ResultStore)EasyMock.createStrictMock(ResultStore.class);
        resultStore.set(((ErrorException)mockErrorExceptionWithCode).resultCode);
        EasyMock.replay((Object[])new Object[]{resultStore});
        ErrorExceptionHandler errorExceptionHandler = new ErrorExceptionHandler(resultStore, (MVCConfiguration)mockConfiguration, messageStore, messageProvider);
        errorExceptionHandler.handle((ErrorException)mockErrorExceptionWithCode);
        EasyMock.verify((Object[])new Object[]{messageProvider, messageStore, resultStore});
    }

    @Test
    public void errorExceptionWithDefaultResultCode() {
        MockErrorException mockErrorException = new MockErrorException();
        MockConfiguration mockConfiguration = new MockConfiguration();
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        EasyMock.expect((Object)messageProvider.getMessage("[" + ((Object)((Object)mockErrorException)).getClass().getSimpleName() + "]", mockErrorException.args)).andReturn((Object)"foo");
        EasyMock.replay((Object[])new Object[]{messageProvider});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        messageStore.add((Message)EasyMock.isA(SimpleMessage.class));
        EasyMock.replay((Object[])new Object[]{messageStore});
        ResultStore resultStore = (ResultStore)EasyMock.createStrictMock(ResultStore.class);
        resultStore.set(mockConfiguration.exceptionResultCode());
        EasyMock.replay((Object[])new Object[]{resultStore});
        ErrorExceptionHandler errorExceptionHandler = new ErrorExceptionHandler(resultStore, (MVCConfiguration)mockConfiguration, messageStore, messageProvider);
        errorExceptionHandler.handle((ErrorException)mockErrorException);
        EasyMock.verify((Object[])new Object[]{messageProvider, messageStore, resultStore});
    }

    @Test
    public void errorExceptionWithNoMessageLookup() {
        ErrorException errorException = new ErrorException("error", false);
        MockConfiguration mockConfiguration = new MockConfiguration();
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        EasyMock.replay((Object[])new Object[]{messageProvider});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.replay((Object[])new Object[]{messageStore});
        ResultStore resultStore = (ResultStore)EasyMock.createStrictMock(ResultStore.class);
        resultStore.set("error");
        EasyMock.replay((Object[])new Object[]{resultStore});
        ErrorExceptionHandler errorExceptionHandler = new ErrorExceptionHandler(resultStore, (MVCConfiguration)mockConfiguration, messageStore, messageProvider);
        errorExceptionHandler.handle(errorException);
        EasyMock.verify((Object[])new Object[]{messageProvider, messageStore, resultStore});
    }

    @Test
    public void validationExceptionWithoutMessage() {
        ValidationException validationException = new ValidationException();
        MockConfiguration mockConfiguration = new MockConfiguration();
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        messageProvider.getMessage("[" + ((Object)((Object)validationException)).getClass().getSimpleName() + "]", validationException.args);
        EasyMock.expectLastCall().andThrow((Throwable)new MissingMessageException());
        EasyMock.replay((Object[])new Object[]{messageProvider});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.replay((Object[])new Object[]{messageStore});
        ResultStore resultStore = (ResultStore)EasyMock.createStrictMock(ResultStore.class);
        resultStore.set(validationException.resultCode);
        EasyMock.replay((Object[])new Object[]{resultStore});
        ErrorExceptionHandler errorExceptionHandler = new ErrorExceptionHandler(resultStore, (MVCConfiguration)mockConfiguration, messageStore, messageProvider);
        errorExceptionHandler.handle((ErrorException)validationException);
        EasyMock.verify((Object[])new Object[]{messageProvider, messageStore, resultStore});
    }

    public static class MockErrorExceptionWithCode
    extends ErrorException {
        public static final String resultCode = "result.code";

        public MockErrorExceptionWithCode() {
            super(resultCode);
        }
    }

    public static class MockErrorException
    extends ErrorException {
        public MockErrorException() {
            super(new Object[0]);
        }
    }
}

