/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.message;

import io.fusionauth.http.server.HTTPRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.primeframework.mvc.message.FieldMessage;
import org.primeframework.mvc.message.Message;
import org.primeframework.mvc.message.MessageObserver;
import org.primeframework.mvc.message.scope.MessageScope;

public class TestMessageObserver
implements MessageObserver {
    public static final String ObserverMessageStoreId = "X-Observer-MessageStoreId";
    public final Map<String, Map<MessageScope, List<Message>>> messages = new ConcurrentHashMap<String, Map<MessageScope, List<Message>>>();
    private String messageStoreId;

    public Map<String, List<FieldMessage>> getFieldMessages() {
        if (this.messageStoreId == null || !this.messages.containsKey(this.messageStoreId)) {
            return Collections.emptyMap();
        }
        List<FieldMessage> list = this.messages.get(this.messageStoreId).values().stream().flatMap(Collection::stream).filter(message -> message instanceof FieldMessage).map(message -> (FieldMessage)message).toList();
        HashMap<String, List<FieldMessage>> hashMap = new HashMap<String, List<FieldMessage>>();
        for (FieldMessage fieldMessage : list) {
            hashMap.computeIfAbsent(fieldMessage.getField(), string -> new ArrayList()).add(fieldMessage);
        }
        return hashMap;
    }

    public List<Message> getGeneralMessages() {
        if (this.messageStoreId == null || !this.messages.containsKey(this.messageStoreId)) {
            return Collections.emptyList();
        }
        return this.messages.get(this.messageStoreId).values().stream().flatMap(Collection::stream).filter(message -> !(message instanceof FieldMessage)).collect(Collectors.toList());
    }

    public void messageAdded(HTTPRequest hTTPRequest, MessageScope messageScope2, Message message) {
        String string2 = hTTPRequest.getHeader(ObserverMessageStoreId);
        if (string2 != null) {
            this.messages.computeIfAbsent(string2, string -> new HashMap()).computeIfAbsent(messageScope2, messageScope -> new ArrayList()).add(message);
        }
    }

    public void reset() {
        this.messages.clear();
    }

    public void scopeCleared(HTTPRequest hTTPRequest, MessageScope messageScope) {
        String string = hTTPRequest.getHeader(ObserverMessageStoreId);
        if (string != null && this.messages.containsKey(string)) {
            this.messages.get(string).remove(messageScope);
        }
    }

    public void setMessageStoreId(String string) {
        this.messageStoreId = string;
    }
}

