/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.security.guice;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.HashMap;
import java.util.Map;
import org.primeframework.mvc.security.SecurityScheme;

public class SecuritySchemeFactory {
    private static final Map<String, Class<? extends SecurityScheme>> bindings = new HashMap<String, Class<? extends SecurityScheme>>();
    private final Injector injector;

    @Inject
    public SecuritySchemeFactory(Injector injector) {
        this.injector = injector;
    }

    public static void addSecurityScheme(Binder binder, String scheme, Class<? extends SecurityScheme> securitySchemeType) {
        binder.bind(securitySchemeType);
        bindings.put(scheme, securitySchemeType);
    }

    public SecurityScheme build(String scheme) {
        Class<? extends SecurityScheme> securitySchemeType = bindings.get(scheme);
        if (securitySchemeType == null) {
            return null;
        }
        return (SecurityScheme)this.injector.getInstance(securitySchemeType);
    }
}

