/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.security;

import io.fusionauth.http.server.HTTPRequest;
import java.util.Set;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.security.SecurityScheme;
import org.primeframework.mvc.security.UnauthenticatedException;
import org.primeframework.mvc.security.UnauthorizedException;

public abstract class AbstractAPISecurityScheme
implements SecurityScheme {
    protected final ActionInvocationStore actionInvocationStore;
    protected final HTTPRequest request;

    protected AbstractAPISecurityScheme(ActionInvocationStore actionInvocationStore, HTTPRequest request) {
        this.actionInvocationStore = actionInvocationStore;
        this.request = request;
    }

    @Override
    public void handle(String[] constraints) {
        ActionInvocation actionInvocation = this.actionInvocationStore.getCurrent();
        String actionURI = actionInvocation.actionURI;
        String authenticationKey = this.authenticationKey();
        if (authenticationKey == null) {
            throw new UnauthenticatedException();
        }
        Set<String> allowedMethods = this.allowedMethods(authenticationKey, actionURI);
        if (!allowedMethods.contains(actionInvocation.method.httpMethod.toString())) {
            throw new UnauthorizedException();
        }
    }

    protected abstract Set<String> allowedMethods(String var1, String var2);

    protected String authenticationKey() {
        String header = this.request.getHeader("Authorization");
        if (header == null) {
            header = this.request.getHeader("Authentication");
        }
        return header;
    }
}

