/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.control.form;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.LocaleUtils;
import org.primeframework.mvc.control.annotation.ControlAttribute;
import org.primeframework.mvc.control.annotation.ControlAttributes;
import org.primeframework.mvc.control.form.Select;

@ControlAttributes(required={@ControlAttribute(name="name", types={String.class})}, optional={@ControlAttribute(name="disabled", types={boolean.class, Boolean.class}), @ControlAttribute(name="includeCountries", types={boolean.class, Boolean.class}), @ControlAttribute(name="multiple", types={boolean.class, Boolean.class}), @ControlAttribute(name="preferredLocales", types={String.class}), @ControlAttribute(name="readonly", types={boolean.class, Boolean.class}), @ControlAttribute(name="required", types={boolean.class, Boolean.class}), @ControlAttribute(name="size", types={int.class, Number.class}), @ControlAttribute(name="tabindex", types={int.class, Number.class})})
public class LocaleSelect
extends Select {
    @Inject
    public LocaleSelect() {
    }

    @Override
    protected Map<String, Object> makeParameters() {
        LinkedHashMap<Locale, String> locales = new LinkedHashMap<Locale, String>();
        String preferred = (String)this.attributes.get("preferredLocales");
        Locale userLocale = (Locale)this.localeProvider.get();
        if (preferred != null) {
            String[] parts;
            for (String part : parts = preferred.split(",")) {
                Locale locale2 = LocaleUtils.toLocale(part);
                locales.put(locale2, locale2.getDisplayName(userLocale));
            }
        }
        boolean includeCountries = this.attributes.containsKey("includeCountries") ? (Boolean)this.attributes.get("includeCountries") : true;
        ArrayList<Locale> allLocales = new ArrayList<Locale>();
        Collections.addAll(allLocales, Locale.getAvailableLocales());
        allLocales.removeIf(locale -> locale.getLanguage().isEmpty() || locale.hasExtensions() || !locale.getScript().isEmpty() || !locale.getVariant().isEmpty() || !includeCountries && !locale.getCountry().isEmpty());
        allLocales.sort(Comparator.comparing(one -> one.getDisplayName(userLocale)));
        for (Locale locale3 : allLocales) {
            if (locales.containsKey(locale3)) continue;
            locales.put(locale3, locale3.getDisplayName(userLocale));
        }
        this.attributes.put("items", locales);
        return super.makeParameters();
    }
}

