/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.content.guice;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.HashMap;
import java.util.Map;
import org.primeframework.mvc.content.ContentHandler;

public class ContentHandlerFactory {
    private static final Map<String, Class<? extends ContentHandler>> bindings = new HashMap<String, Class<? extends ContentHandler>>();
    private final Injector injector;

    @Inject
    public ContentHandlerFactory(Injector injector) {
        this.injector = injector;
    }

    public static void addContentHandler(Binder binder, String contentType, Class<? extends ContentHandler> handlerType) {
        binder.bind(handlerType);
        bindings.put(contentType, handlerType);
    }

    public ContentHandler build(String contentType) {
        Class<? extends ContentHandler> handlerType = bindings.get(contentType);
        if (handlerType == null && contentType != null) {
            handlerType = bindings.get(contentType);
        }
        if (handlerType == null) {
            handlerType = bindings.get("");
        }
        return (ContentHandler)this.injector.getInstance(handlerType);
    }
}

