/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action.result;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.CollectionModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModelException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.primeframework.mvc.control.Control;
import org.primeframework.mvc.control.FreeMarkerControlProxy;
import org.primeframework.mvc.control.guice.ControlFactory;
import org.primeframework.mvc.freemarker.FreeMarkerRenderException;

public class ControlsHashModel
implements TemplateHashModelEx {
    private final ControlFactory controlFactory;
    private final Map<String, FreeMarkerControlProxy> controls = new HashMap<String, FreeMarkerControlProxy>();
    private final ObjectWrapper objectWrapper;
    private final String prefix;

    public ControlsHashModel(String prefix, ControlFactory controlFactory, ObjectWrapper objectWrapper) {
        this.prefix = prefix;
        this.controlFactory = controlFactory;
        this.objectWrapper = objectWrapper;
    }

    public FreeMarkerControlProxy get(String key) {
        FreeMarkerControlProxy proxy = this.controls.get(key);
        if (proxy == null) {
            Control control = this.controlFactory.build(this.prefix, key);
            if (control == null) {
                throw new FreeMarkerRenderException("Prime control named [" + key + "] doesn't exist. Currently registered controls are " + String.valueOf(this.controls.keySet()));
            }
            proxy = new FreeMarkerControlProxy(control, this.objectWrapper);
            this.controls.put(key, proxy);
        }
        return proxy;
    }

    public boolean isEmpty() {
        return this.controlFactory.controlNames(this.prefix).isEmpty();
    }

    public TemplateCollectionModel keys() throws TemplateModelException {
        return new CollectionModel(this.controlFactory.controlNames(this.prefix), (BeansWrapper)this.objectWrapper);
    }

    public int size() {
        return this.controlFactory.controlNames(this.prefix).size();
    }

    public TemplateCollectionModel values() {
        return new CollectionModel(this.valueCollection(), (BeansWrapper)this.objectWrapper);
    }

    private Collection<FreeMarkerControlProxy> valueCollection() {
        return this.controlFactory.controlNames(this.prefix).stream().map(this::get).collect(Collectors.toList());
    }
}

