/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action;

import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPRequest;
import java.util.ArrayDeque;
import java.util.Deque;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;

public class DefaultActionInvocationStore
implements ActionInvocationStore {
    public static final String ACTION_INVOCATION_DEQUE_KEY = "primeActionInvocationDeque";
    public static final String ACTION_INVOCATION_KEY = "primeActionInvocation";
    private final HTTPRequest request;

    @Inject
    public DefaultActionInvocationStore(HTTPRequest request) {
        this.request = request;
    }

    @Override
    public ActionInvocation getCurrent() {
        Deque deque = (Deque)this.request.getAttribute(ACTION_INVOCATION_DEQUE_KEY);
        if (deque == null) {
            return null;
        }
        return (ActionInvocation)deque.peek();
    }

    @Override
    public void setCurrent(ActionInvocation actionInvocation) {
        ArrayDeque<ActionInvocation> deque = (ArrayDeque<ActionInvocation>)this.request.getAttribute(ACTION_INVOCATION_DEQUE_KEY);
        if (deque == null) {
            deque = new ArrayDeque<ActionInvocation>();
            this.request.setAttribute(ACTION_INVOCATION_DEQUE_KEY, deque);
        }
        deque.push(actionInvocation);
        this.request.setAttribute(ACTION_INVOCATION_KEY, (Object)actionInvocation);
    }

    @Override
    public Deque<ActionInvocation> getDeque() {
        return (Deque)this.request.getAttribute(ACTION_INVOCATION_DEQUE_KEY);
    }

    @Override
    public void removeCurrent() {
        Deque deque = (Deque)this.request.getAttribute(ACTION_INVOCATION_DEQUE_KEY);
        if (deque == null) {
            return;
        }
        deque.poll();
        this.request.removeAttribute(ACTION_INVOCATION_KEY);
    }
}

