/*
 * Copyright (c) 2012, Inversoft Inc., All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */
package org.primeframework.mvc.control.form;

import java.util.LinkedHashMap;
import java.util.Map;

import org.primeframework.mvc.control.annotation.ControlAttribute;
import org.primeframework.mvc.control.annotation.ControlAttributes;

/**
 * This class is the control for a US state select box.
 *
 * @author Brian Pontarelli
 */
@ControlAttributes(
    required = {
        @ControlAttribute(name = "name", types = {String.class})
    },
    optional = {
        @ControlAttribute(name = "disabled", types = {boolean.class, Boolean.class}),
        @ControlAttribute(name = "includeBlank", types = {boolean.class, Boolean.class}),
        @ControlAttribute(name = "multiple", types = {boolean.class, Boolean.class}),
        @ControlAttribute(name = "readonly", types = {boolean.class, Boolean.class}),
        @ControlAttribute(name = "required", types = {boolean.class, Boolean.class}),
        @ControlAttribute(name = "size", types = {int.class, Number.class}),
        @ControlAttribute(name = "tabindex", types = {int.class, Number.class})
    }
)
public class StateSelect extends Select {
  /**
   * Adds the states to a Map and then calls super.
   */
  @Override
  protected Map<String, Object> makeParameters() {
    LinkedHashMap<String, String> states = new LinkedHashMap<String, String>();

    if (attributes.containsKey("includeBlank") && (Boolean) attributes.get("includeBlank")) {
      states.put("", "");
    }

    states.put("AL", "Alabama");
    states.put("AK", "Alaska");
    states.put("AZ", "Arizona");
    states.put("AR", "Arkansas");
    states.put("CA", "California");
    states.put("CO", "Colorado");
    states.put("CT", "Connecticut");
    states.put("DC", "District of Columbia");
    states.put("DE", "Delaware");
    states.put("FL", "Florida");
    states.put("GA", "Georgia");
    states.put("HI", "Hawaii");
    states.put("ID", "Idaho");
    states.put("IL", "Illinois");
    states.put("IN", "Indiana");
    states.put("IA", "Iowa");
    states.put("KA", "Kansas");
    states.put("KY", "Kentucky");
    states.put("LA", "Louisiana");
    states.put("ME", "Maine");
    states.put("MD", "Maryland");
    states.put("MA", "Massachusetts");
    states.put("MI", "Michigan");
    states.put("MN", "Minnesota");
    states.put("MS", "Mississippi");
    states.put("MO", "Missouri");
    states.put("MT", "Montana");
    states.put("NE", "Nebraska");
    states.put("NV", "Nevada");
    states.put("NH", "New Hampshire");
    states.put("NJ", "New Jersey");
    states.put("NM", "New Mexico");
    states.put("NY", "New York");
    states.put("NC", "North Carolina");
    states.put("ND", "North Dakota");
    states.put("OH", "Ohio");
    states.put("OK", "Oklahoma");
    states.put("OR", "Oregon");
    states.put("PA", "Pennsylvania");
    states.put("RI", "Rhode Island");
    states.put("SC", "South Carolina");
    states.put("SD", "South Dakota");
    states.put("TN", "Tennessee");
    states.put("TX", "Texas");
    states.put("UT", "Utah");
    states.put("VT", "Vermont");
    states.put("VA", "Virginia");
    states.put("WA", "Washington");
    states.put("WV", "West Virginia");
    states.put("WI", "Wisconsin");
    states.put("WY", "Wyoming");

    attributes.put("items", states);

    return super.makeParameters();
  }
}