/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter;

import java.util.Arrays;
import java.util.HashSet;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.action.annotation.Action;
import org.primeframework.mvc.action.config.ActionConfigurator;
import org.primeframework.mvc.action.config.DefaultActionConfigurationBuilder;
import org.primeframework.mvc.content.binary.BinaryActionConfigurator;
import org.primeframework.mvc.content.json.JacksonActionConfigurator;
import org.primeframework.mvc.parameter.annotation.FieldName;
import org.primeframework.mvc.parameter.el.BeanExpressionException;
import org.primeframework.mvc.util.DefaultURIBuilder;
import org.primeframework.mvc.util.URIBuilder;
import org.testng.annotations.Test;

public class FieldNameTest {
    @Test
    public void test() {
        DefaultActionConfigurationBuilder defaultActionConfigurationBuilder = new DefaultActionConfigurationBuilder((URIBuilder)new DefaultURIBuilder(), new HashSet<ActionConfigurator>(Arrays.asList(new JacksonActionConfigurator(), new BinaryActionConfigurator())));
        this.expectException(DuplicateSetters1.class, "Invalid JavaBean class [class org.primeframework.mvc.parameter.FieldNameTest$DuplicateSetters1]. Errors are:\n[Two or more [set] methods named [setBar] exist. Rename or remove the duplicate method.]");
        this.expectException(DuplicateSetters2.class, "Invalid JavaBean class [class org.primeframework.mvc.parameter.FieldNameTest$DuplicateSetters2]. Errors are:\n[Two or more [set] methods named [setBar] exist. Rename or remove the duplicate method.]");
        this.expectException(DuplicateFields1.class, "Invalid JavaBean class [class org.primeframework.mvc.parameter.FieldNameTest$DuplicateFields1]. Errors are:\n[A field annotated with FieldName] and value of [foo] effectively duplicates the existing field of the same name. Rename or remove the duplicate field.]");
        defaultActionConfigurationBuilder.build(OkayAction.class);
    }

    private void expectException(Class<?> clazz, String string) {
        PrimeBaseTest.expectException(BeanExpressionException.class, () -> new DefaultActionConfigurationBuilder((URIBuilder)new DefaultURIBuilder(), new HashSet<ActionConfigurator>(Arrays.asList(new JacksonActionConfigurator(), new BinaryActionConfigurator()))).build(clazz), String.format(string, clazz));
    }

    @Action
    private static class DuplicateSetters1 {
        public String target;

        private DuplicateSetters1() {
        }

        public String get() {
            return "success";
        }

        @FieldName(value="target")
        public void setBar(String string) {
            this.target = string;
        }

        public void setTarget(String string) {
            this.target = string;
        }
    }

    @Action
    private static class DuplicateSetters2 {
        private DuplicateSetters2() {
        }

        public String get() {
            return "success";
        }

        @FieldName(value="target")
        public void setBar(String string) {
        }

        @FieldName(value="target")
        public void setFoo(String string) {
        }
    }

    @Action
    private static class DuplicateFields1 {
        @FieldName(value="foo")
        public String bar;
        public String foo;

        private DuplicateFields1() {
        }

        public String get() {
            return "success";
        }

        public void setFoo(String string) {
            this.foo = string;
        }
    }

    @Action
    private static class OkayAction {
        @FieldName(value="buzz")
        public String foo;
        private String bar;

        private OkayAction() {
        }

        public String get() {
            return "success";
        }

        @FieldName(value="baz")
        public void setBar(String string) {
            this.bar = string;
        }
    }
}

