/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter;

import io.fusionauth.http.HTTPMethod;
import java.util.List;
import org.easymock.EasyMock;
import org.example.action.ComplexRestAction;
import org.example.action.user.EditAction;
import org.example.action.user.RESTEdit;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.parameter.DefaultURIParameterWorkflow;
import org.primeframework.mvc.workflow.WorkflowChain;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DefaultURIParameterWorkflowTest
extends PrimeBaseTest {
    @Test
    public void complexParameters() throws Exception {
        ComplexRestAction complexRestAction = new ComplexRestAction();
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        ActionInvocation actionInvocation = this.makeActionInvocation(complexRestAction, HTTPMethod.POST, "", this.map("firstName", List.of("brian"), "lastName", List.of("pontarelli"), "theRest", List.of("then", "a", "bunch", "of", "stuff")));
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation);
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        DefaultURIParameterWorkflow defaultURIParameterWorkflow = new DefaultURIParameterWorkflow(this.request, actionInvocationStore);
        defaultURIParameterWorkflow.perform(workflowChain);
        Assert.assertEquals((String)this.request.getParameter("firstName"), (String)"brian");
        Assert.assertEquals((String)this.request.getParameter("lastName"), (String)"pontarelli");
        Assert.assertEquals((String)((String)this.request.getParameters("theRest").get(0)), (String)"then");
        Assert.assertEquals((String)((String)this.request.getParameters("theRest").get(1)), (String)"a");
        Assert.assertEquals((String)((String)this.request.getParameters("theRest").get(2)), (String)"bunch");
        Assert.assertEquals((String)((String)this.request.getParameters("theRest").get(3)), (String)"of");
        Assert.assertEquals((String)((String)this.request.getParameters("theRest").get(4)), (String)"stuff");
        EasyMock.verify((Object[])new Object[]{actionInvocationStore, workflowChain});
    }

    @Test
    public void noParameters() throws Exception {
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        ActionInvocation actionInvocation = this.makeActionInvocation(new EditAction(), HTTPMethod.POST, "");
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation);
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        DefaultURIParameterWorkflow defaultURIParameterWorkflow = new DefaultURIParameterWorkflow(this.request, actionInvocationStore);
        defaultURIParameterWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{actionInvocationStore, workflowChain});
    }

    @Test
    public void singleIDParameters() throws Exception {
        RESTEdit rESTEdit = new RESTEdit();
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        ActionInvocation actionInvocation = this.makeActionInvocation(rESTEdit, HTTPMethod.POST, "", this.map("id", List.of("12")));
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation);
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        DefaultURIParameterWorkflow defaultURIParameterWorkflow = new DefaultURIParameterWorkflow(this.request, actionInvocationStore);
        defaultURIParameterWorkflow.perform(workflowChain);
        Assert.assertEquals((String)this.request.getParameter("id"), (String)"12");
        EasyMock.verify((Object[])new Object[]{actionInvocationStore, workflowChain});
    }
}

