/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.control.form;

import com.google.inject.Inject;
import org.example.action.user.EditAction;
import org.example.domain.User;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.control.Control;
import org.primeframework.mvc.control.ControlBaseTest;
import org.primeframework.mvc.control.form.Text;
import org.primeframework.mvc.message.Message;
import org.primeframework.mvc.message.MessageType;
import org.primeframework.mvc.message.SimpleFieldMessage;
import org.testng.annotations.Test;

public class TextTest
extends ControlBaseTest {
    @Inject
    public Text text;

    @Test
    public void action() {
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setName("Brian");
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/text", null, null));
        new ControlBaseTest.ControlTester((Control)this.text).attr("name", "user.name").go("<input type=\"hidden\" name=\"user.name@param\" value=\"param-value\"/>\n<div class=\"text input control\">\n<div class=\"label-container\"><label for=\"user_name\" class=\"label\">Your name</label></div>\n<div class=\"control-container\"><input type=\"text\" id=\"user_name\" name=\"user.name\" value=\"Brian\"/></div>\n</div>\n");
    }

    @Test
    public void actionLess() {
        this.ais.setCurrent(new ActionInvocation(null, null, "/text", null, null));
        new ControlBaseTest.ControlTester((Control)this.text).attr("name", "test").attr("class", "css-class").go("<input type=\"hidden\" name=\"test@param\" value=\"param-value\"/>\n<div class=\"css-class-text css-class-input css-class-control text input control\">\n<div class=\"label-container\"><label for=\"test\" class=\"label\">Test</label></div>\n<div class=\"control-container\"><input type=\"text\" class=\"css-class\" id=\"test\" name=\"test\"/></div>\n</div>\n");
    }

    @Test
    public void defaultValue() {
        EditAction editAction = new EditAction();
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/text", null, null));
        new ControlBaseTest.ControlTester((Control)this.text).attr("name", "user.name").attr("defaultValue", "John").go("<input type=\"hidden\" name=\"user.name@param\" value=\"param-value\"/>\n<div class=\"text input control\">\n<div class=\"label-container\"><label for=\"user_name\" class=\"label\">Your name</label></div>\n<div class=\"control-container\"><input type=\"text\" id=\"user_name\" name=\"user.name\" value=\"John\"/></div>\n</div>\n");
    }

    @Test
    public void fieldErrors() {
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setName("Barry");
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/text", null, null));
        this.messageStore.add((Message)new SimpleFieldMessage(MessageType.ERROR, "user.name", "code1", "fieldError1"));
        this.messageStore.add((Message)new SimpleFieldMessage(MessageType.ERROR, "user.name", "code2", "fieldError2"));
        new ControlBaseTest.ControlTester((Control)this.text).attr("name", "user.name").go("<input type=\"hidden\" name=\"user.name@param\" value=\"param-value\"/>\n<div class=\"text input control\">\n<div class=\"label-container\"><label for=\"user_name\" class=\"label\"><span class=\"error\">Your name (fieldError1, fieldError2)</span></label></div>\n<div class=\"control-container\"><input type=\"text\" id=\"user_name\" name=\"user.name\" value=\"Barry\"/></div>\n</div>\n");
    }

    @Test
    public void hardCodedValue() {
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setName("Brian");
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/text", null, null));
        new ControlBaseTest.ControlTester((Control)this.text).attr("name", "user.name").attr("value", "Barry").go("<input type=\"hidden\" name=\"user.name@param\" value=\"param-value\"/>\n<div class=\"text input control\">\n<div class=\"label-container\"><label for=\"user_name\" class=\"label\">Your name</label></div>\n<div class=\"control-container\"><input type=\"text\" id=\"user_name\" name=\"user.name\" value=\"Barry\"/></div>\n</div>\n");
    }

    @Test
    public void html() {
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setName("<Brian>");
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/text", null, null));
        new ControlBaseTest.ControlTester((Control)this.text).attr("name", "user.name").go("<input type=\"hidden\" name=\"user.name@param\" value=\"param-value\"/>\n<div class=\"text input control\">\n<div class=\"label-container\"><label for=\"user_name\" class=\"label\">Your name</label></div>\n<div class=\"control-container\"><input type=\"text\" id=\"user_name\" name=\"user.name\" value=\"&lt;Brian&gt;\"/></div>\n</div>\n");
        editAction.user.setName("'Brian'");
        new ControlBaseTest.ControlTester((Control)this.text).attr("name", "user.name").go("<input type=\"hidden\" name=\"user.name@param\" value=\"param-value\"/>\n<div class=\"text input control\">\n<div class=\"label-container\"><label for=\"user_name\" class=\"label\">Your name</label></div>\n<div class=\"control-container\"><input type=\"text\" id=\"user_name\" name=\"user.name\" value=\"&#39;Brian&#39;\"/></div>\n</div>\n");
        editAction.user.setName("\"Brian\"");
        new ControlBaseTest.ControlTester((Control)this.text).attr("name", "user.name").go("<input type=\"hidden\" name=\"user.name@param\" value=\"param-value\"/>\n<div class=\"text input control\">\n<div class=\"label-container\"><label for=\"user_name\" class=\"label\">Your name</label></div>\n<div class=\"control-container\"><input type=\"text\" id=\"user_name\" name=\"user.name\" value=\"&quot;Brian&quot;\"/></div>\n</div>\n");
        editAction.user.setName("&Brian&");
        new ControlBaseTest.ControlTester((Control)this.text).attr("name", "user.name").go("<input type=\"hidden\" name=\"user.name@param\" value=\"param-value\"/>\n<div class=\"text input control\">\n<div class=\"label-container\"><label for=\"user_name\" class=\"label\">Your name</label></div>\n<div class=\"control-container\"><input type=\"text\" id=\"user_name\" name=\"user.name\" value=\"&amp;Brian&amp;\"/></div>\n</div>\n");
    }

    @Test
    public void labelKey() {
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setName("Brian");
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/text", null, null));
        new ControlBaseTest.ControlTester((Control)this.text).attr("name", "user.name").attr("labelKey", "label-key").go("<input type=\"hidden\" name=\"user.name@param\" value=\"param-value\"/>\n<div class=\"text input control\">\n<div class=\"label-container\"><label for=\"user_name\" class=\"label\">Foo bar</label></div>\n<div class=\"control-container\"><input type=\"text\" id=\"user_name\" name=\"user.name\" value=\"Brian\"/></div>\n</div>\n");
    }
}

