/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc;

import com.google.inject.Inject;
import io.fusionauth.http.HTTPMethod;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.primeframework.mvc.action.ExecuteMethodConfiguration;
import org.primeframework.mvc.action.config.ActionConfiguration;
import org.primeframework.mvc.action.config.ActionConfigurationProvider;

public class RoutePrinter {
    @Inject
    private ActionConfigurationProvider provider;

    public void dump(boolean bl, boolean bl2, String ... stringArray) {
        List<ActionConfiguration> list = this.provider.getActionConfigurations().stream().filter(actionConfiguration -> !this.ignoreActionClass((ActionConfiguration)actionConfiguration, stringArray)).sorted(Comparator.comparing(actionConfiguration -> actionConfiguration.uri)).toList();
        int[] nArray = new int[]{0, 0};
        list.forEach(actionConfiguration -> {
            nArray[0] = Math.max(nArray[0], actionConfiguration.uri.length() + 2);
            String string = actionConfiguration.actionClass.getName();
            nArray[1] = Math.max(nArray[1], string.length() + 2);
        });
        list.forEach(actionConfiguration -> {
            String string = actionConfiguration.executeMethods.entrySet().stream().map(this::formatMethod).collect(Collectors.joining(", "));
            Object object = actionConfiguration.uri;
            if (!actionConfiguration.pattern.isEmpty()) {
                object = (String)object + "/" + actionConfiguration.pattern;
            }
            System.out.printf("%-" + nArray[0] + "s", object);
            if (bl2) {
                System.out.printf("%-" + nArray[1] + "s", actionConfiguration.actionClass.getName());
            }
            if (bl) {
                System.out.print(string);
            }
            System.out.println();
        });
    }

    private boolean ignoreActionClass(ActionConfiguration actionConfiguration, String ... stringArray) {
        String string = actionConfiguration.actionClass.getProtectionDomain().getCodeSource().getLocation().getPath();
        return Arrays.stream(stringArray).anyMatch(string::contains);
    }

    private String formatMethod(Map.Entry<HTTPMethod, ExecuteMethodConfiguration> entry) {
        HTTPMethod hTTPMethod = entry.getKey();
        String string = entry.getValue().method.getName();
        if (string.equals(hTTPMethod.name().toLowerCase())) {
            return hTTPMethod.name();
        }
        return String.format("%s->%s", hTTPMethod, string);
    }
}

