/*
 * Decompiled with CFR 0.152.
 */
package org.example.action;

import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPRequest;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.primeframework.mvc.action.annotation.Action;
import org.primeframework.mvc.action.result.annotation.Status;
import org.primeframework.mvc.message.Message;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.message.MessageType;
import org.primeframework.mvc.message.SimpleMessage;
import org.primeframework.mvc.message.l10n.MessageProvider;

@Action
@Status
public class CallbackAction {
    private final MessageProvider messageProvider;
    private final MessageStore messageStore;
    private final HTTPRequest request;

    @Inject
    public CallbackAction(HTTPRequest hTTPRequest, MessageProvider messageProvider, MessageStore messageStore) {
        this.messageProvider = messageProvider;
        this.messageStore = messageStore;
        this.request = hTTPRequest;
    }

    public String get() {
        this.messageStore.add((Message)new SimpleMessage(MessageType.ERROR, "[ERROR]", this.messageProvider.getMessage("[ERROR]", new Object[0])));
        this.messageStore.add((Message)new SimpleMessage(MessageType.INFO, "[INFO]", this.messageProvider.getMessage("[INFO]", new Object[0])));
        this.messageStore.add((Message)new SimpleMessage(MessageType.WARNING, "[WARNING]", this.messageProvider.getMessage("[WARNING]", new Object[0])));
        URI uRI = URI.create(this.request.getBaseURL() + "/message-store");
        HttpRequest httpRequest = HttpRequest.newBuilder(uRI).GET().build();
        HttpClient httpClient = HttpClient.newBuilder().build();
        try {
            httpClient.send(httpRequest, HttpResponse.BodyHandlers.discarding());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return "success";
    }
}

