/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.convert.converters;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.primeframework.mvc.MockConfiguration;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.parameter.convert.ConversionException;
import org.primeframework.mvc.parameter.convert.GlobalConverter;
import org.primeframework.mvc.parameter.convert.converters.ZonedDateTimeConverter;
import org.primeframework.mvc.util.MapBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ZonedDateTimeConverterTest
extends PrimeBaseTest {
    @Test
    public void fromStrings() {
        ZonedDateTimeConverter zonedDateTimeConverter = new ZonedDateTimeConverter((MVCConfiguration)new MockConfiguration());
        ZonedDateTime zonedDateTime = (ZonedDateTime)zonedDateTimeConverter.convertFromStrings(ZonedDateTime.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{null}));
        Assert.assertNull((Object)zonedDateTime);
        zonedDateTime = (ZonedDateTime)zonedDateTimeConverter.convertFromStrings(Locale.class, MapBuilder.asMap((Object[])new String[]{"dateTimeFormat", "MM-dd-yyyy hh:mm:ss a Z"}), "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"07-08-2008 10:13:34 AM -0800"}));
        Assert.assertEquals((int)zonedDateTime.getMonthValue(), (int)7);
        Assert.assertEquals((int)zonedDateTime.getDayOfMonth(), (int)8);
        Assert.assertEquals((int)zonedDateTime.getYear(), (int)2008);
        Assert.assertEquals((int)zonedDateTime.getHour(), (int)10);
        Assert.assertEquals((int)zonedDateTime.getMinute(), (int)13);
        Assert.assertEquals((int)zonedDateTime.getSecond(), (int)34);
        Assert.assertEquals((Object)zonedDateTime.getZone(), (Object)ZoneOffset.ofHours(-8));
        ZonedDateTimeConverterTest.expectException(ConversionException.class, () -> ZonedDateTimeConverterTest.lambda$fromStrings$0((GlobalConverter)zonedDateTimeConverter));
        zonedDateTimeConverter.convertFromStrings(Locale.class, MapBuilder.asMap((Object[])new String[]{"dateTimeFormat", "[MM-dd-yyyy hh:mm:ss a Z][MM/dd/yyyy hh;mm;ss a Z]"}), "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"07-08-2008 10:13:34 AM -0800"}));
        zonedDateTimeConverter.convertFromStrings(Locale.class, MapBuilder.asMap((Object[])new String[]{"dateTimeFormat", "[MM-dd-yyyy hh:mm:ss a Z][MM/dd/yyyy hh;mm;ss a Z]"}), "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"07/08/2008 10;13;34 AM -0800"}));
        ZonedDateTimeConverterTest.expectException(ConversionException.class, () -> ZonedDateTimeConverterTest.lambda$fromStrings$1((GlobalConverter)zonedDateTimeConverter));
    }

    @Test
    public void toStrings() {
        ZonedDateTimeConverter zonedDateTimeConverter = new ZonedDateTimeConverter((MVCConfiguration)new MockConfiguration());
        String string = zonedDateTimeConverter.convertToString(ZonedDateTime.class, null, "testExpr", null);
        Assert.assertNull((Object)string);
        string = zonedDateTimeConverter.convertToString(ZonedDateTime.class, MapBuilder.asMap((Object[])new String[]{"dateTimeFormat", "MM-dd-yyyy"}), "testExpr", (Object)ZonedDateTime.of(2008, 7, 8, 1, 1, 1, 0, ZoneId.systemDefault()));
        Assert.assertEquals((String)string, (String)"07-08-2008");
        string = zonedDateTimeConverter.convertToString(ZonedDateTime.class, MapBuilder.asMap((Object[])new String[]{"dateTimeFormat", "[MM-dd-yyyy][MM/dd/yyyy]"}), "testExpr", (Object)ZonedDateTime.of(2008, 7, 8, 1, 1, 1, 0, ZoneId.systemDefault()));
        Assert.assertEquals((String)string, (String)"07-08-2008");
        string = zonedDateTimeConverter.convertToString(ZonedDateTime.class, MapBuilder.asMap((Object[])new String[]{"dateTimeFormat", "[MM/dd/yyyy][MM-dd-yyyy]"}), "testExpr", (Object)ZonedDateTime.of(2008, 7, 8, 1, 1, 1, 0, ZoneId.systemDefault()));
        Assert.assertEquals((String)string, (String)"07/08/2008");
    }

    private static /* synthetic */ void lambda$fromStrings$1(GlobalConverter globalConverter) throws Exception {
        globalConverter.convertFromStrings(Locale.class, MapBuilder.asMap((Object[])new String[]{"dateTimeFormat", "[MM-dd-yyyy hh:mm:ss a Z][MM/dd/yyyy hh;mm;ss a Z]"}), "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"07_08_2008 10;13;34 AM -0800"}));
    }

    private static /* synthetic */ void lambda$fromStrings$0(GlobalConverter globalConverter) throws Exception {
        globalConverter.convertFromStrings(Locale.class, MapBuilder.asMap((Object[])new String[]{"dateTimeFormat", "MM-dd-yyyy"}), "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"07/08/2008"}));
    }
}

