/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.convert.converters;

import java.util.UUID;
import org.primeframework.mvc.MockConfiguration;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.parameter.convert.ConversionException;
import org.primeframework.mvc.parameter.convert.converters.UUIDConverter;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UUIDConverterTest {
    @Test
    public void fromStrings() {
        UUIDConverter uUIDConverter = new UUIDConverter((MVCConfiguration)new MockConfiguration());
        UUID uUID = (UUID)uUIDConverter.convertFromStrings(UUID.class, null, "testExpr", new String[]{null});
        Assert.assertNull((Object)uUID);
        uUID = (UUID)uUIDConverter.convertFromStrings(UUID.class, null, "testExpr", new String[]{"   "});
        Assert.assertNull((Object)uUID);
        UUID uUID2 = UUID.randomUUID();
        uUID = (UUID)uUIDConverter.convertFromStrings(UUID.class, null, "testExpr", new String[]{uUID2.toString()});
        Assert.assertEquals((Object)uUID, (Object)uUID2);
        uUID = (UUID)uUIDConverter.convertFromStrings(UUID.class, null, "testExpr", new String[]{"1"});
        Assert.assertEquals((Object)uUID, (Object)new UUID(0L, 1L));
        uUID = (UUID)uUIDConverter.convertFromStrings(UUID.class, null, "testExpr", new String[]{"4242"});
        Assert.assertEquals((Object)uUID, (Object)new UUID(0L, 4242L));
        try {
            uUIDConverter.convertFromStrings(UUID.class, null, "testExpr", new String[]{"NotAUUID"});
            Assert.fail((String)"Should throw an exception");
        }
        catch (ConversionException conversionException) {
        }
        catch (Throwable throwable) {
            Assert.fail((String)"Should have thrown a ConversionException");
        }
    }

    @Test
    public void toStrings() {
        UUIDConverter uUIDConverter = new UUIDConverter((MVCConfiguration)new MockConfiguration());
        String string = uUIDConverter.convertToString(UUID.class, null, "testExpr", null);
        Assert.assertNull((Object)string);
        UUID uUID = UUID.randomUUID();
        string = uUIDConverter.convertToString(UUID.class, null, "testExpr", (Object)uUID);
        Assert.assertEquals((String)string, (String)uUID.toString());
        string = uUIDConverter.convertToString(UUID.class, null, "testExpr", (Object)new UUID(0L, 1L));
        Assert.assertEquals((String)string, (String)"1");
        string = uUIDConverter.convertToString(UUID.class, null, "testExpr", (Object)new UUID(0L, 4242L));
        Assert.assertEquals((String)string, (String)"4242");
    }
}

