/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.convert.converters;

import java.io.File;
import java.util.HashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.primeframework.mvc.parameter.convert.converters.FileConverter;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FileConverterTest {
    @Test
    public void fromStrings() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        FileConverter fileConverter = new FileConverter();
        File file = (File)fileConverter.convertFromStrings(File.class, hashMap, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{null}));
        Assert.assertNull((Object)file);
        file = (File)fileConverter.convertFromStrings(File.class, hashMap, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{""}));
        Assert.assertNull((Object)file);
        file = (File)fileConverter.convertFromStrings(File.class, hashMap, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"/tmp"}));
        Assert.assertEquals((String)file.getAbsolutePath(), (String)"/tmp");
        file = (File)fileConverter.convertFromStrings(File.class, hashMap, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"/tmp", "prime"}));
        Assert.assertEquals((String)file.getAbsolutePath(), (String)"/tmp/prime");
        file = (File)fileConverter.convertFromStrings(File.class, hashMap, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"build.savant"}));
        Assert.assertEquals((String)file.getAbsolutePath(), (String)new File("build.savant").getAbsolutePath());
        File[] fileArray = (File[])fileConverter.convertFromStrings(File[].class, hashMap, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"build.savant", "build.xml"}));
        Assert.assertEquals((String)fileArray[0].getAbsolutePath(), (String)new File("build.savant").getAbsolutePath());
        Assert.assertEquals((String)fileArray[1].getAbsolutePath(), (String)new File("build.xml").getAbsolutePath());
        hashMap.put("parentDir", "/tmp");
        file = (File)fileConverter.convertFromStrings(File.class, hashMap, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"build.savant"}));
        Assert.assertEquals((String)file.getAbsolutePath(), (String)new File("/tmp/build.savant").getAbsolutePath());
    }

    @Test
    public void toStrings() {
        FileConverter fileConverter = new FileConverter();
        String string = fileConverter.convertToString(File.class, null, "testExpr", null);
        Assert.assertNull((Object)string);
        string = fileConverter.convertToString(File.class, null, "testExpr", (Object)new File("build.savant"));
        Assert.assertEquals((String)string, (String)new File("build.savant").getAbsolutePath());
    }
}

