/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.io.IOException;
import org.primeframework.mvc.CloseableModule;
import org.primeframework.mvc.MockConfiguration;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.cors.CORSConfigurationProvider;
import org.primeframework.mvc.cors.NoCORSConfigurationProvider;
import org.primeframework.mvc.guice.GuiceBootstrap;
import org.primeframework.mvc.guice.MVCModule;
import org.primeframework.mvc.guice.TestClosable;
import org.primeframework.mvc.security.MockUserLoginSecurityContext;
import org.primeframework.mvc.security.UserLoginSecurityContext;
import org.primeframework.mvc.workflow.MVCWorkflow;
import org.primeframework.mvc.workflow.WorkflowChain;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GuiceBootstrapTest
extends PrimeBaseTest {
    @Test
    public void overrideModules() {
        Injector injector = GuiceBootstrap.initialize((Module[])new Module[]{Modules.override((Module[])new Module[]{new MVCModule()}).with(new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(MVCWorkflow.class).to(TestMVCWorkflow.class);
                this.bind(MVCConfiguration.class).to(MockConfiguration.class);
                this.bind(UserLoginSecurityContext.class).to(MockUserLoginSecurityContext.class);
            }
        }})});
        Assert.assertSame((Object)((MVCWorkflow)injector.getInstance(MVCWorkflow.class)).getClass(), TestMVCWorkflow.class);
    }

    @Test
    public void shutdownAndExplicitModules() {
        Injector injector = GuiceBootstrap.initialize((Module[])new Module[]{new MVCModule(this){

            protected void configure() {
                super.configure();
                this.bind(MVCConfiguration.class).toInstance((Object)new MockConfiguration(2, 1, false, false));
                this.bind(UserLoginSecurityContext.class).to(MockUserLoginSecurityContext.class);
                this.bind(CORSConfigurationProvider.class).to(NoCORSConfigurationProvider.class);
                this.install(new CloseableModule());
            }
        }});
        Assert.assertNotNull((Object)injector.getInstance(TestClosable.class));
        Assert.assertTrue((boolean)((TestClosable)injector.getInstance(TestClosable.class)).open);
        GuiceBootstrap.shutdown((Injector)injector);
        Assert.assertFalse((boolean)((TestClosable)injector.getInstance(TestClosable.class)).open);
    }

    public static class TestMVCWorkflow
    implements MVCWorkflow {
        public void perform(WorkflowChain workflowChain) throws IOException {
        }
    }
}

