/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.scope;

import com.google.inject.Inject;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.config.ActionConfiguration;
import org.primeframework.mvc.scope.Scope;
import org.primeframework.mvc.scope.ScopeField;
import org.primeframework.mvc.scope.ScopeProvider;
import org.primeframework.mvc.scope.ScopeRetriever;
import org.primeframework.mvc.util.ReflectionUtils;
import org.primeframework.mvc.util.TypeTools;

public class DefaultScopeRetriever
implements ScopeRetriever {
    private final ScopeProvider scopeProvider;

    @Inject
    public DefaultScopeRetriever(ScopeProvider scopeProvider) {
        this.scopeProvider = scopeProvider;
    }

    @Override
    public void setScopedValues(ActionInvocation actionInvocation) {
        List<ScopeField> scopeFields;
        ActionConfiguration actionConfiguration = actionInvocation.configuration;
        List<ScopeField> list = scopeFields = actionConfiguration != null ? actionConfiguration.scopeFields : null;
        if (actionInvocation.action != null && scopeFields != null && scopeFields.size() > 0) {
            for (ScopeField scopeField : scopeFields) {
                Object value;
                Scope scope = this.scopeProvider.lookup(scopeField.annotationType);
                Type type = scopeField.field.getGenericType();
                if (type instanceof TypeVariable) {
                    type = TypeTools.resolveGenericType(scopeField.field.getDeclaringClass(), actionInvocation.action.getClass(), (TypeVariable)type);
                } else if (type instanceof ParameterizedType) {
                    type = ((ParameterizedType)type).getRawType();
                }
                if ((value = scope.get(scopeField.field.getName(), (Class)type, scopeField.annotation)) == null) continue;
                ReflectionUtils.setField(scopeField.field, actionInvocation.action, value);
            }
        }
    }
}

