/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.convert;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import org.primeframework.mvc.parameter.convert.AnnotationConverter;
import org.primeframework.mvc.parameter.convert.ConverterProvider;
import org.primeframework.mvc.parameter.convert.GlobalConverter;
import org.primeframework.mvc.parameter.convert.annotation.ConverterAnnotation;

public class DefaultConverterProvider
implements ConverterProvider {
    private final Map<Class<?>, GlobalConverter> converters;
    private final Injector injector;

    @Inject
    public DefaultConverterProvider(Injector injector, Map<Class<?>, GlobalConverter> converters) {
        this.injector = injector;
        this.converters = converters;
    }

    @Override
    public GlobalConverter lookup(Class<?> type) {
        Class inter;
        Class<?> localType = type;
        while (localType.isArray()) {
            localType = localType.getComponentType();
        }
        while (localType != null && localType != Object.class) {
            GlobalConverter converter = this.converters.get(localType);
            if (converter == null) {
                localType = localType.getSuperclass();
                continue;
            }
            return converter;
        }
        localType = type;
        LinkedList interfaces = new LinkedList(Arrays.asList(type.getInterfaces()));
        while ((inter = (Class)interfaces.poll()) != null) {
            GlobalConverter converter = this.converters.get(inter);
            if (converter != null) {
                return converter;
            }
            interfaces.addAll(Arrays.asList(inter.getInterfaces()));
            if (interfaces.size() != 0 || localType.isInterface() || (localType = localType.getSuperclass()) == Object.class) continue;
            interfaces.addAll(Arrays.asList(localType.getInterfaces()));
        }
        return null;
    }

    @Override
    public AnnotationConverter lookup(Annotation annotation) {
        ConverterAnnotation ra = annotation.annotationType().getAnnotation(ConverterAnnotation.class);
        return (AnnotationConverter)this.injector.getInstance(ra.value());
    }
}

