/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action.result;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fusionauth.http.Cookie;
import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import java.net.URI;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.security.Encryptor;
import org.primeframework.mvc.security.SavedRequestException;
import org.primeframework.mvc.security.saved.SavedHttpRequest;
import org.primeframework.mvc.util.CookieTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SavedRequestTools {
    private static final Logger logger = LoggerFactory.getLogger(SavedRequestTools.class);

    public static SaveHttpRequestResult getSaveRequestForReExecution(MVCConfiguration configuration, Encryptor encryptor, ObjectMapper objectMapper, HTTPRequest request, HTTPResponse response) {
        SaveHttpRequestResult result = SavedRequestTools.getSaveHttpRequestResult(configuration, encryptor, objectMapper, request, response);
        if (result == null || result.savedHttpRequest == null) {
            return null;
        }
        if (result.savedHttpRequest.method == HTTPMethod.GET) {
            result.cookie.maxAge = 0L;
            result.cookie.path = "/";
        } else {
            result.cookie.maxAge = null;
            result.cookie.path = "/";
            result.cookie.value = "ready_" + result.cookie.value;
        }
        result.cookie.sameSite = configuration.savedRequestCookieSameSite();
        response.addCookie(result.cookie);
        return result;
    }

    public static SaveHttpRequestResult getSaveRequestForWorkflow(MVCConfiguration configuration, Encryptor encryptor, ObjectMapper objectMapper, HTTPRequest request, HTTPResponse response) {
        SaveHttpRequestResult result = SavedRequestTools.getSaveHttpRequestResult(configuration, encryptor, objectMapper, request, response);
        if (result == null) {
            return null;
        }
        if (!result.ready) {
            return null;
        }
        result.cookie.path = "/";
        result.cookie.maxAge = 0L;
        response.addCookie(result.cookie);
        return result;
    }

    public static Cookie toCookie(SavedHttpRequest savedRequest, MVCConfiguration configuration, Encryptor encryptor, ObjectMapper objectMapper) {
        try {
            String value = CookieTools.toJSONCookie(savedRequest, true, true, encryptor, objectMapper);
            Cookie cookie = new Cookie(configuration.savedRequestCookieName(), value);
            cookie.path = "/";
            cookie.httpOnly = true;
            cookie.sameSite = configuration.savedRequestCookieSameSite();
            cookie.secure = "https".equalsIgnoreCase(URI.create(savedRequest.uri).getScheme());
            return cookie;
        }
        catch (Exception e) {
            throw new SavedRequestException(e);
        }
    }

    private static Cookie getCookie(MVCConfiguration configuration, HTTPRequest request) {
        return request.getCookie(configuration.savedRequestCookieName());
    }

    private static SaveHttpRequestResult getSaveHttpRequestResult(MVCConfiguration configuration, Encryptor encryptor, ObjectMapper objectMapper, HTTPRequest request, HTTPResponse response) {
        Cookie cookie = SavedRequestTools.getCookie(configuration, request);
        if (cookie == null) {
            return null;
        }
        try {
            String value = cookie.value;
            boolean ready = value.startsWith("ready_");
            if (ready) {
                value = value.substring("ready_".length());
            }
            SavedHttpRequest savedRequest = CookieTools.fromJSONCookie(value, SavedHttpRequest.class, true, true, encryptor, objectMapper);
            return new SaveHttpRequestResult(cookie, ready, savedRequest);
        }
        catch (Exception e) {
            logger.warn("Bad SavedRequest cookie [{}]. Error is [{}]", (Object)cookie.value, (Object)e.getMessage());
            cookie.maxAge = 0L;
            cookie.path = "/";
            response.addCookie(cookie);
            return null;
        }
    }

    public static class SaveHttpRequestResult {
        public Cookie cookie;
        public boolean ready;
        public SavedHttpRequest savedHttpRequest;

        public SaveHttpRequestResult(Cookie cookie, boolean ready, SavedHttpRequest savedHttpRequest) {
            this.cookie = cookie;
            this.ready = ready;
            this.savedHttpRequest = savedHttpRequest;
        }
    }
}

