/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action.result;

import io.fusionauth.http.server.HTTPResponse;
import java.io.IOException;
import java.lang.annotation.Annotation;
import org.primeframework.mvc.PrimeException;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.result.AbstractResult;
import org.primeframework.mvc.action.result.ResourceLocator;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.freemarker.FreeMarkerMap;
import org.primeframework.mvc.freemarker.FreeMarkerService;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;

public abstract class AbstractForwardResult<U extends Annotation>
extends AbstractResult<U> {
    private final ActionInvocationStore actionInvocationStore;
    private final MVCConfiguration configuration;
    private final FreeMarkerMap freeMarkerMap;
    private final FreeMarkerService freeMarkerService;
    private final ResourceLocator resourceLocator;
    private final HTTPResponse response;

    protected AbstractForwardResult(ActionInvocationStore actionInvocationStore, ExpressionEvaluator expressionEvaluator, ResourceLocator resourceLocator, FreeMarkerService freeMarkerService, HTTPResponse response, FreeMarkerMap freeMarkerMap, MVCConfiguration configuration) {
        super(expressionEvaluator);
        this.resourceLocator = resourceLocator;
        this.response = response;
        this.freeMarkerMap = freeMarkerMap;
        this.freeMarkerService = freeMarkerService;
        this.actionInvocationStore = actionInvocationStore;
        this.configuration = configuration;
    }

    @Override
    public boolean execute(U forward) throws IOException {
        String page;
        ActionInvocation actionInvocation = this.actionInvocationStore.getCurrent();
        Object action = actionInvocation.action;
        if (action == null && (page = this.resourceLocator.locate(this.configuration.templateDirectory())) == null) {
            return false;
        }
        String contentType = this.expand(this.getContentType(forward), action, false);
        this.response.setContentType(contentType);
        this.setStatus(this.getStatus(forward), this.getStatusStr(forward), action, this.response);
        this.addCacheControlHeader(forward, this.response);
        if (this.isHeadRequest(actionInvocation)) {
            return true;
        }
        page = this.buildFullyQualifiedPath(actionInvocation, forward);
        this.freeMarkerService.render(this.response.getWriter(), page, this.freeMarkerMap);
        return true;
    }

    protected String expandPage(String page, ActionInvocation actionInvocation) {
        return this.expand(page, actionInvocation.action, false);
    }

    protected abstract String getCode(U var1);

    protected abstract String getContentType(U var1);

    protected abstract String getPage(U var1);

    protected abstract int getStatus(U var1);

    protected abstract String getStatusStr(U var1);

    private String buildFullyQualifiedPath(ActionInvocation actionInvocation, U forward) {
        Object page = this.getPage(forward);
        if (((String)page).equals("")) {
            page = this.locateDefault(actionInvocation, forward);
        } else if (((String)page).startsWith("/")) {
            page = this.configuration.templateDirectory() + (String)page;
        } else {
            String uri = actionInvocation.actionURI;
            int index = uri.lastIndexOf(47);
            if (index >= 0) {
                uri = uri.substring(0, index);
            }
            page = this.configuration.templateDirectory() + uri + "/" + (String)page;
        }
        return this.expandPage((String)page, actionInvocation);
    }

    private String locateDefault(ActionInvocation actionInvocation, U forward) {
        String page = this.resourceLocator.locate(this.configuration.templateDirectory());
        if (page == null) {
            throw new PrimeException("Missing result for action class [" + actionInvocation.configuration.actionClass.getName() + "] URI [" + actionInvocation.uri() + "] and result code [" + this.getCode(forward) + "]");
        }
        return page;
    }
}

