/*
 * Copyright (c) 2016-2018, Inversoft Inc., All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */
package org.primeframework.mvc.parameter;

import java.io.IOException;

import com.google.inject.Inject;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.parameter.annotation.PostParameterMethod;
import org.primeframework.mvc.workflow.WorkflowChain;

/**
 * This class handles the invocation of all action methods annotated with {@link PostParameterMethod}
 *
 * @author Daniel DeGroff
 */
public class DefaultPostParameterWorkflow implements PostParameterWorkflow {

  private final ActionInvocationStore actionInvocationStore;

  private final PostParameterHandler postParameterHandler;

  @Inject
  public DefaultPostParameterWorkflow(ActionInvocationStore actionInvocationStore,
                                      PostParameterHandler postParameterHandle) {
    this.actionInvocationStore = actionInvocationStore;
    this.postParameterHandler = postParameterHandle;
  }

  @Override
  public void perform(WorkflowChain workflowChain) throws IOException {
    ActionInvocation actionInvocation = actionInvocationStore.getCurrent();
    invokeMethods(actionInvocation);

    workflowChain.continueWorkflow();
  }

  protected void invokeMethods(ActionInvocation actionInvocation) {
    postParameterHandler.handle(actionInvocation);
  }
}
