/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http;

import io.fusionauth.http.BaseTest;
import io.fusionauth.http.server.HTTPHandler;
import io.fusionauth.http.server.HTTPServer;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.testng.Assert;

public abstract class BaseSocketTest
extends BaseTest {
    protected Builder withRequest(String string) {
        return new Builder(string);
    }

    private void assertResponse(String string, String string2, String string3) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPRequest.getInputStream().readAllBytes();
            hTTPResponse.setStatus(200);
        };
        try (HTTPServer hTTPServer = ((HTTPServer)((HTTPServer)((HTTPServer)((HTTPServer)((HTTPServer)((HTTPServer)this.makeServer("http", hTTPHandler).withReadThroughputCalculationDelayDuration(Duration.ofMinutes(2L))).withWriteThroughputCalculationDelayDuration(Duration.ofMinutes(2L))).withKeepAliveTimeoutDuration(Duration.ofSeconds(23L))).withInitialReadTimeout(Duration.ofSeconds(19L))).withProcessingTimeoutDuration(Duration.ofSeconds(27L))).withRequestBufferSize(512)).start();
             Socket socket = this.makeClientSocket("http");){
            socket.setSoTimeout((int)Duration.ofSeconds(30L).toMillis());
            String string4 = "These pretzels are making me thirsty. ";
            int n = hTTPServer.configuration().getRequestBufferSize();
            String string5 = string4.repeat(n / string4.length() * 2);
            if (string.contains("Transfer-Encoding: chunked")) {
                string5 = new String(this.chunkEncode(string5.getBytes(StandardCharsets.UTF_8), 100, string2));
            }
            string = string.replace("{body}", string5);
            int n2 = string5.getBytes(StandardCharsets.UTF_8).length;
            string = string.replace("{contentLength}", "" + n2);
            int n3 = string.indexOf("\r\n\r\n") + 4;
            String string6 = string.substring(n3);
            Assert.assertEquals((int)n2, (int)string6.getBytes(StandardCharsets.UTF_8).length, (String)"Check the value you provided for 'withRequest' it looks like you may have a trailing line return or something.\n");
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(string.getBytes(StandardCharsets.UTF_8));
            this.assertHTTPResponseEquals(socket, string3);
        }
    }

    protected class Builder {
        public String chunkedExtension;
        public String request;

        public Builder(String string) {
            this.request = string;
        }

        public void expectResponse(String string) throws Exception {
            BaseSocketTest.this.assertResponse(this.request, this.chunkedExtension, string);
        }

        public Builder withChunkedExtension(String string) {
            this.chunkedExtension = string;
            return this;
        }
    }
}

