/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server.io;

import io.fusionauth.http.ContentTooLargeException;
import io.fusionauth.http.io.ChunkedInputStream;
import io.fusionauth.http.io.FixedLengthInputStream;
import io.fusionauth.http.io.PushbackInputStream;
import io.fusionauth.http.log.Logger;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPServerConfiguration;
import io.fusionauth.http.server.Instrumenter;
import io.fusionauth.http.server.io.TooManyBytesToDrainException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public class HTTPInputStream
extends InputStream {
    private final byte[] b1 = new byte[1];
    private final int chunkedBufferSize;
    private final Instrumenter instrumenter;
    private final Logger logger;
    private final int maximumBytesToDrain;
    private final int maximumContentLength;
    private final PushbackInputStream pushbackInputStream;
    private final HTTPRequest request;
    private int bytesRead;
    private boolean closed;
    private InputStream delegate;
    private boolean drained;
    private boolean initialized;

    public HTTPInputStream(HTTPServerConfiguration hTTPServerConfiguration, HTTPRequest hTTPRequest, PushbackInputStream pushbackInputStream, int n) {
        this.logger = hTTPServerConfiguration.getLoggerFactory().getLogger(HTTPInputStream.class);
        this.instrumenter = hTTPServerConfiguration.getInstrumenter();
        this.request = hTTPRequest;
        this.delegate = pushbackInputStream;
        this.pushbackInputStream = pushbackInputStream;
        this.chunkedBufferSize = hTTPServerConfiguration.getChunkedBufferSize();
        this.maximumBytesToDrain = hTTPServerConfiguration.getMaxBytesToDrain();
        this.maximumContentLength = n;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.drained) {
            return;
        }
        this.drain();
    }

    public int drain() throws IOException {
        int n;
        if (this.drained) {
            return 0;
        }
        this.drained = true;
        int n2 = 0;
        byte[] byArray = new byte[2048];
        while ((n = this.read(byArray)) >= 0) {
            if ((n2 += n) <= this.maximumBytesToDrain) continue;
            throw new TooManyBytesToDrainException(n2, this.maximumBytesToDrain);
        }
        return n2;
    }

    @Override
    public int read() throws IOException {
        int n = this.read(this.b1);
        if (n <= 0) {
            return n;
        }
        return this.b1[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if (n2 == 0) {
            return 0;
        }
        if (!this.initialized) {
            this.initialize();
        }
        if ((n4 = this.delegate.read(byArray, n, n3 = this.maximumContentLength == -1 ? n2 : Math.min(n2, this.maximumContentLength - this.bytesRead + 1))) > 0) {
            this.bytesRead += n4;
        }
        if (this.maximumContentLength != -1 && this.bytesRead > this.maximumContentLength) {
            String string = "The maximum request size has been exceeded. The maximum request size is [" + this.maximumContentLength + "] bytes.";
            throw new ContentTooLargeException((long)this.maximumContentLength, string);
        }
        return n4;
    }

    private void initialize() throws IOException {
        this.initialized = true;
        boolean bl = this.request.hasBody();
        if (bl) {
            Long l = this.request.getContentLength();
            if (this.request.isChunked()) {
                this.logger.trace("Client indicated it was sending an entity-body in the request. Handling body using chunked encoding.");
                this.delegate = new ChunkedInputStream(this.pushbackInputStream, this.chunkedBufferSize);
                if (this.instrumenter != null) {
                    this.instrumenter.chunkedRequest();
                }
            } else {
                this.logger.trace("Client indicated it was sending an entity-body in the request. Handling body using Content-Length header {}.", l);
                this.delegate = new FixedLengthInputStream(this.pushbackInputStream, l);
            }
            for (String string : this.request.getContentEncodings().reversed()) {
                if (string.equalsIgnoreCase("deflate")) {
                    this.delegate = new InflaterInputStream(this.delegate);
                    continue;
                }
                if (!string.equalsIgnoreCase("gzip")) continue;
                this.delegate = new GZIPInputStream(this.delegate);
            }
            if (l != null && this.maximumContentLength != -1 && l > (long)this.maximumContentLength) {
                String string = "The maximum request size has been exceeded. The reported Content-Length is [" + l + "] and the maximum request size is [" + this.maximumContentLength + "] bytes.";
                throw new ContentTooLargeException((long)this.maximumContentLength, string);
            }
        } else {
            this.logger.trace("Client indicated it was NOT sending an entity-body in the request");
            this.delegate = InputStream.nullInputStream();
        }
    }
}

