/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server.internal;

import io.fusionauth.http.log.Logger;
import io.fusionauth.http.security.SecurityTools;
import io.fusionauth.http.server.HTTPListenerConfiguration;
import io.fusionauth.http.server.HTTPServerConfiguration;
import io.fusionauth.http.server.Instrumenter;
import io.fusionauth.http.server.internal.HTTPWorker;
import io.fusionauth.http.server.io.Throughput;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.net.ssl.SSLContext;

public class HTTPServerThread
extends Thread {
    private final HTTPServerCleanerThread cleaner;
    private final Deque<ClientInfo> clients = new ConcurrentLinkedDeque<ClientInfo>();
    private final HTTPServerConfiguration configuration;
    private final Instrumenter instrumenter;
    private final HTTPListenerConfiguration listener;
    private final Logger logger;
    private final long minimumReadThroughput;
    private final long minimumWriteThroughput;
    private final ServerSocket socket;
    private volatile boolean running;

    public HTTPServerThread(HTTPServerConfiguration hTTPServerConfiguration, HTTPListenerConfiguration hTTPListenerConfiguration) throws IOException, GeneralSecurityException {
        super("HTTP server [" + hTTPListenerConfiguration.getBindAddress().toString() + ":" + hTTPListenerConfiguration.getPort() + "]");
        this.configuration = hTTPServerConfiguration;
        this.listener = hTTPListenerConfiguration;
        this.instrumenter = hTTPServerConfiguration.getInstrumenter();
        this.logger = hTTPServerConfiguration.getLoggerFactory().getLogger(HTTPServerThread.class);
        this.minimumReadThroughput = hTTPServerConfiguration.getMinimumReadThroughput();
        this.minimumWriteThroughput = hTTPServerConfiguration.getMinimumWriteThroughput();
        this.cleaner = new HTTPServerCleanerThread();
        if (hTTPListenerConfiguration.isTLS()) {
            SSLContext sSLContext = SecurityTools.serverContext(hTTPListenerConfiguration.getCertificateChain(), hTTPListenerConfiguration.getPrivateKey());
            this.socket = sSLContext.getServerSocketFactory().createServerSocket();
        } else {
            this.socket = new ServerSocket();
        }
        this.socket.setSoTimeout(0);
        this.socket.bind(new InetSocketAddress(hTTPListenerConfiguration.getBindAddress(), hTTPListenerConfiguration.getPort()), hTTPServerConfiguration.getMaxPendingSocketConnections());
        if (this.instrumenter != null) {
            this.instrumenter.serverStarted();
        }
    }

    @Override
    public void run() {
        this.running = true;
        this.cleaner.start();
        while (this.running) {
            try {
                Socket socket = this.socket.accept();
                socket.setSoTimeout((int)this.configuration.getInitialReadTimeoutDuration().toMillis());
                if (this.logger.isTraceEnabled()) {
                    String string = this.listener.getBindAddress().toString() + ":" + this.listener.getPort();
                    this.logger.trace("[{}] Accepted inbound connection. [{}] existing connections.", string, this.clients.size());
                }
                if (this.instrumenter != null) {
                    this.instrumenter.acceptedConnection();
                }
                Throughput object = new Throughput(this.configuration.getReadThroughputCalculationDelay().toMillis(), this.configuration.getWriteThroughputCalculationDelay().toMillis());
                HTTPWorker hTTPWorker = new HTTPWorker(socket, this.configuration, this.instrumenter, this.listener, object);
                Thread thread = Thread.ofVirtual().name("HTTP client [" + String.valueOf(socket.getRemoteSocketAddress()) + "]").start(hTTPWorker);
                this.clients.add(new ClientInfo(thread, hTTPWorker, object));
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.logger.debug("Nothing accepted. Cleaning up existing connections.");
            }
            catch (SocketException socketException) {
                if (this.socket.isClosed()) {
                    this.running = false;
                    this.logger.debug("The server socket was closed. Shutting down the server.");
                    continue;
                }
                this.logger.error("An exception was thrown while accepting incoming connections.", socketException);
            }
            catch (IOException iOException) {
                this.logger.debug("IO exception. Likely a fuzzer or a bad client or a TLS issue, all of which are common and can mostly be ignored.");
            }
            catch (Throwable throwable) {
                this.logger.error("An exception was thrown during server processing. This is a fatal issue and we need to shutdown the server.", throwable);
                break;
            }
        }
        for (ClientInfo clientInfo : this.clients) {
            clientInfo.thread().interrupt();
        }
    }

    public void shutdown() {
        this.running = false;
        try {
            this.cleaner.interrupt();
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class HTTPServerCleanerThread
    extends Thread {
        public HTTPServerCleanerThread() {
            super("Cleaner for HTTP server [" + HTTPServerThread.this.listener.getBindAddress().toString() + ":" + HTTPServerThread.this.listener.getPort() + "]");
        }

        @Override
        public void run() {
            while (HTTPServerThread.this.running) {
                int n = HTTPServerThread.this.clients.size();
                int n2 = 0;
                HTTPServerThread.this.logger.trace("Wake up. Review [{}] client worker threads for cleanup.", n);
                Iterator<ClientInfo> iterator = HTTPServerThread.this.clients.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    ClientInfo clientInfo = iterator.next();
                    Thread thread = clientInfo.thread();
                    long l = thread.threadId();
                    if (!thread.isAlive()) {
                        HTTPServerThread.this.logger.trace("[{}] Remove dead client worker. Born [{}]. Died at age [{}] ms. Requests handled [{}].", l, clientInfo.getStartInstant(), clientInfo.getAge(), clientInfo.getHandledRequests());
                        iterator.remove();
                        ++n2;
                        continue;
                    }
                    long l2 = System.currentTimeMillis();
                    Throughput throughput = clientInfo.throughput();
                    HTTPWorker hTTPWorker = clientInfo.runnable();
                    HTTPWorker.State state = hTTPWorker.state();
                    long l3 = throughput.lastUsed();
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    long l4 = -1L;
                    long l5 = -1L;
                    String string = "[" + l + "] Check worker in state [" + String.valueOf((Object)state) + "]";
                    if (state == HTTPWorker.State.Read) {
                        l4 = throughput.readThroughput(l2);
                        bl = bl4 = l4 < HTTPServerThread.this.minimumReadThroughput;
                        string = string + " readingSlow=[" + bl + "] readThroughput=[" + l4 + "] minimumReadThroughput=[" + HTTPServerThread.this.minimumReadThroughput + "]";
                    } else if (state == HTTPWorker.State.Write) {
                        l5 = throughput.writeThroughput(l2);
                        bl2 = bl4 = l5 < HTTPServerThread.this.minimumWriteThroughput;
                        string = string + " writingSlow=[" + bl2 + "] writeThroughput=[" + l5 + "] minimumWriteThroughput=[" + HTTPServerThread.this.minimumWriteThroughput + "]";
                    } else if (state == HTTPWorker.State.Process) {
                        long l6 = l2 - l3;
                        bl3 = bl4 = l6 > HTTPServerThread.this.configuration.getProcessingTimeoutDuration().toMillis();
                        string = string + " timedOut=[" + bl3 + "] waited=[" + l6 + "] processingTimeoutDuration=[" + HTTPServerThread.this.configuration.getProcessingTimeoutDuration().toMillis() + "]";
                    }
                    if (!bl4) {
                        HTTPServerThread.this.logger.trace("[{}] Check worker in state [{}]", new Object[]{l, state});
                        continue;
                    }
                    HTTPServerThread.this.logger.debug(string);
                    iterator.remove();
                    ++n2;
                    Object object2 = "";
                    if (HTTPServerThread.this.logger.isDebugEnabled()) {
                        if (bl) {
                            object2 = (String)object2 + String.format(" Min read throughput [%s], actual throughput [%s].", HTTPServerThread.this.minimumReadThroughput, l4);
                        }
                        if (bl2) {
                            object2 = (String)object2 + String.format(" Min write throughput [%s], actual throughput [%s].", HTTPServerThread.this.minimumWriteThroughput, l5);
                        }
                        if (bl3) {
                            object2 = (String)object2 + String.format(" Connection timed out while processing. Last used [%s]ms ago. Configured client timeout [%s]ms.", l2 - l3, HTTPServerThread.this.configuration.getProcessingTimeoutDuration().toMillis());
                        }
                        HTTPServerThread.this.logger.debug("[{}] Closing connection readingSlow=[{}] writingSlow=[{}] timedOut=[{}] {}", l, bl, bl2, bl3, object2);
                        HTTPServerThread.this.logger.debug("[{}] Closing client connection [{}] due to inactivity", l, hTTPWorker.getSocket().getRemoteSocketAddress());
                    }
                    if (HTTPServerThread.this.logger.isTraceEnabled()) {
                        object = new StringBuilder();
                        for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
                            ((StringBuilder)object).append(entry.getKey()).append(" ").append((Object)entry.getKey().getState()).append("\n");
                            for (StackTraceElement stackTraceElement : entry.getValue()) {
                                ((StringBuilder)object).append("\tat ").append(stackTraceElement).append("\n");
                            }
                            ((StringBuilder)object).append("\n");
                        }
                        HTTPServerThread.this.logger.trace("Thread dump from server side.\n" + String.valueOf(object));
                    }
                    try {
                        object = hTTPWorker.getSocket();
                        ((Socket)object).close();
                        if (HTTPServerThread.this.instrumenter == null) continue;
                        HTTPServerThread.this.instrumenter.connectionClosed();
                    }
                    catch (IOException iOException) {
                        HTTPServerThread.this.logger.debug(String.format("[%s] Unable to close connection to client. [{}]", l), iOException);
                    }
                }
                if (n > 0) {
                    HTTPServerThread.this.logger.trace("Cleanup removed [{}] clients", n2);
                }
                try {
                    HTTPServerCleanerThread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    record ClientInfo(Thread thread, HTTPWorker runnable, Throughput throughput) {
        public long getAge() {
            return System.currentTimeMillis() - this.runnable().getStartInstant();
        }

        public long getHandledRequests() {
            return this.runnable().getHandledRequests();
        }

        public long getStartInstant() {
            return this.runnable().getStartInstant();
        }
    }
}

