/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.io;

import io.fusionauth.http.io.PushbackInputStream;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPServerConfiguration;
import io.fusionauth.http.server.io.HTTPInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HTTPInputStreamTest {
    @Test
    public void read_chunked_withPushback() throws Exception {
        String string = "These pretzels are making me thirsty. These pretzels are making me thirsty. These pretzels are making me thirsty.";
        int n = string.getBytes(StandardCharsets.UTF_8).length;
        byte[] byArray = "26\r\nThese pretzels are making me thirsty. \r\n26\r\nThese pretzels are making me thirsty. \r\n25\r\nThese pretzels are making me thirsty.\r\n0\r\n\r\nGET / HTTP/1.1\r\n".getBytes();
        HTTPRequest hTTPRequest = new HTTPRequest();
        hTTPRequest.setHeader("Transfer-Encoding", "chunked");
        this.assertReadWithPushback(byArray, string, n, hTTPRequest);
    }

    @Test
    public void read_fixedLength_withPushback() throws Exception {
        String string = "These pretzels are making me thirsty. These pretzels are making me thirsty. These pretzels are making me thirsty.";
        int n = string.getBytes(StandardCharsets.UTF_8).length;
        byte[] byArray = (string + "GET / HTTP/1.1\r\n").getBytes(StandardCharsets.UTF_8);
        HTTPRequest hTTPRequest = new HTTPRequest();
        hTTPRequest.setHeader("Content-Length", "" + n);
        this.assertReadWithPushback(byArray, string, n, hTTPRequest);
    }

    private void assertReadWithPushback(byte[] byArray, String string, int n, HTTPRequest hTTPRequest) throws Exception {
        int n2 = byArray.length;
        HTTPServerConfiguration hTTPServerConfiguration = new HTTPServerConfiguration().withRequestBufferSize(n2 + 100);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        PushbackInputStream pushbackInputStream = new PushbackInputStream((InputStream)byteArrayInputStream, null);
        HTTPInputStream hTTPInputStream = new HTTPInputStream(hTTPServerConfiguration, hTTPRequest, pushbackInputStream, -1);
        byte[] byArray2 = new byte[hTTPServerConfiguration.getRequestBufferSize()];
        int n3 = hTTPInputStream.read(byArray2);
        Assert.assertEquals((int)n3, (int)n);
        Assert.assertEquals((String)new String(byArray2, 0, n3), (String)string);
        int n4 = hTTPInputStream.read(byArray2);
        Assert.assertEquals((int)n4, (int)-1);
        Assert.assertEquals((int)pushbackInputStream.getAvailableBufferedBytesRemaining(), (int)16);
        byte[] byArray3 = new byte[100];
        int n5 = pushbackInputStream.read(byArray3);
        Assert.assertEquals((int)n5, (int)16);
        Assert.assertEquals((String)new String(byArray3, 0, n5), (String)"GET / HTTP/1.1\r\n");
    }
}

