/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server.io;

import io.fusionauth.http.ContentTooLargeException;
import io.fusionauth.http.io.ChunkedInputStream;
import io.fusionauth.http.io.PushbackInputStream;
import io.fusionauth.http.log.Logger;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPServerConfiguration;
import io.fusionauth.http.server.Instrumenter;
import io.fusionauth.http.server.io.TooManyBytesToDrainException;
import java.io.IOException;
import java.io.InputStream;

public class HTTPInputStream
extends InputStream {
    private final byte[] b1 = new byte[1];
    private final int chunkedBufferSize;
    private final Instrumenter instrumenter;
    private final Logger logger;
    private final int maximumBytesToDrain;
    private final int maximumContentLength;
    private final PushbackInputStream pushbackInputStream;
    private final HTTPRequest request;
    private int bytesRead;
    private long bytesRemaining;
    private boolean closed;
    private boolean committed;
    private InputStream delegate;
    private boolean drained;

    public HTTPInputStream(HTTPServerConfiguration hTTPServerConfiguration, HTTPRequest hTTPRequest, PushbackInputStream pushbackInputStream, int n) {
        this.logger = hTTPServerConfiguration.getLoggerFactory().getLogger(HTTPInputStream.class);
        this.instrumenter = hTTPServerConfiguration.getInstrumenter();
        this.request = hTTPRequest;
        this.delegate = pushbackInputStream;
        this.pushbackInputStream = pushbackInputStream;
        this.chunkedBufferSize = hTTPServerConfiguration.getChunkedBufferSize();
        this.maximumBytesToDrain = hTTPServerConfiguration.getMaxBytesToDrain();
        this.maximumContentLength = n;
        if (hTTPRequest.getContentLength() != null) {
            this.bytesRemaining = hTTPRequest.getContentLength();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.drained) {
            return;
        }
        this.drain();
    }

    public int drain() throws IOException {
        int n;
        if (this.drained) {
            return 0;
        }
        this.drained = true;
        int n2 = 0;
        byte[] byArray = new byte[2048];
        while ((n = this.read(byArray)) >= 0) {
            if ((n2 += n) <= this.maximumBytesToDrain) continue;
            throw new TooManyBytesToDrainException(n2, this.maximumBytesToDrain);
        }
        return n2;
    }

    @Override
    public int read() throws IOException {
        int n = this.read(this.b1);
        if (n <= 0) {
            return n;
        }
        return this.b1[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        boolean bl;
        if (n2 == 0) {
            return 0;
        }
        boolean bl2 = bl = !this.request.isChunked();
        if (bl && this.bytesRemaining <= 0L) {
            return -1;
        }
        if (!this.committed) {
            this.commit();
        }
        int n4 = this.maximumContentLength == -1 ? n2 : Math.min(n2, this.maximumContentLength - this.bytesRead + 1);
        int n5 = n3 = this.delegate.read(byArray, n, n4);
        if (bl && n3 > 0) {
            int n6 = (int)((long)n3 - this.bytesRemaining);
            if (n6 > 0) {
                n5 -= n6;
                this.pushbackInputStream.push(byArray, (int)this.bytesRemaining, n6);
            }
            this.bytesRemaining -= (long)n5;
        }
        this.bytesRead += n5;
        if (this.maximumContentLength != -1 && this.bytesRead > this.maximumContentLength) {
            String string = "The maximum request size has been exceeded. The maximum request size is [" + this.maximumContentLength + "] bytes.";
            throw new ContentTooLargeException((long)this.maximumContentLength, string);
        }
        return n5;
    }

    private void commit() {
        boolean bl;
        this.committed = true;
        Long l = this.request.getContentLength();
        boolean bl2 = bl = l != null && l > 0L || this.request.isChunked();
        if (!bl) {
            this.delegate = InputStream.nullInputStream();
        } else if (this.request.isChunked()) {
            this.logger.trace("Client indicated it was sending an entity-body in the request. Handling body using chunked encoding.");
            this.delegate = new ChunkedInputStream(this.pushbackInputStream, this.chunkedBufferSize);
            if (this.instrumenter != null) {
                this.instrumenter.chunkedRequest();
            }
        } else if (l != null) {
            this.logger.trace("Client indicated it was sending an entity-body in the request. Handling body using Content-Length header {}.", l);
        } else {
            this.logger.trace("Client indicated it was NOT sending an entity-body in the request");
        }
        if (l != null && this.maximumContentLength != -1 && l > (long)this.maximumContentLength) {
            String string = "The maximum request size has been exceeded. The reported Content-Length is [" + l + "] and the maximum request size is [" + this.maximumContentLength + "] bytes.";
            throw new ContentTooLargeException((long)this.maximumContentLength, string);
        }
    }
}

