/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.io;

import io.fusionauth.http.server.Instrumenter;
import java.io.IOException;
import java.io.InputStream;

public class PushbackInputStream
extends InputStream {
    private final byte[] b1 = new byte[1];
    private final InputStream delegate;
    private final Instrumenter instrumenter;
    private byte[] buffer;
    private int bufferEndPosition;
    private int bufferPosition;

    public PushbackInputStream(InputStream inputStream, Instrumenter instrumenter) {
        this.delegate = inputStream;
        this.instrumenter = instrumenter;
    }

    public int getAvailableBufferedBytesRemaining() {
        return this.buffer != null ? this.bufferEndPosition - this.bufferPosition : 0;
    }

    public void push(byte[] byArray, int n, int n2) {
        if (this.buffer != null) {
            throw new IllegalStateException("You are not allowed to push more bytes back on to the InputStream until you have read the previously pushed bytes.");
        }
        this.buffer = byArray;
        this.bufferPosition = n;
        this.bufferEndPosition = n + n2;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.buffer != null) {
            int n3 = Math.min(n2, this.bufferEndPosition - this.bufferPosition);
            System.arraycopy(this.buffer, this.bufferPosition, byArray, n, n3);
            this.bufferPosition += n3;
            if (this.bufferPosition >= this.bufferEndPosition) {
                this.buffer = null;
                this.bufferPosition = -1;
                this.bufferEndPosition = -1;
            }
            return n3;
        }
        int n4 = this.delegate.read(byArray, n, n2);
        if (n4 > 0 && this.instrumenter != null) {
            this.instrumenter.readFromClient(n4);
        }
        return n4;
    }

    @Override
    public int read() throws IOException {
        int n = this.read(this.b1);
        if (n <= 0) {
            return n;
        }
        return this.b1[0] & 0xFF;
    }
}

