/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.util;

import io.fusionauth.http.Cookie;
import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.HTTPValues;
import io.fusionauth.http.ParseException;
import io.fusionauth.http.RequestHeadersTooLargeException;
import io.fusionauth.http.io.PushbackInputStream;
import io.fusionauth.http.log.Logger;
import io.fusionauth.http.log.LoggerFactory;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import io.fusionauth.http.server.io.ConnectionClosedException;
import io.fusionauth.http.util.RequestPreambleState;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class HTTPTools {
    private static Logger logger;

    public static int getMaxRequestBodySize(String string, Map<String, Integer> map) {
        if (string == null) {
            return map.get("*");
        }
        Integer n = map.get(string);
        if (n != null) {
            return n;
        }
        int n2 = string.indexOf(47);
        if (n2 != -1) {
            n = map.get(string.substring(0, n2) + "/*");
        }
        return n != null ? n : map.get("*");
    }

    public static void initialize(LoggerFactory loggerFactory) {
        logger = loggerFactory.getLogger(HTTPTools.class);
    }

    public static boolean isControlCharacter(byte by) {
        return by >= 0 && by <= 31;
    }

    public static boolean isDigitCharacter(byte by) {
        return by >= 48 && by <= 57;
    }

    public static boolean isHexadecimalCharacter(byte by) {
        return by >= 48 && by <= 57 || by >= 97 && by <= 102 || by >= 65 && by <= 70;
    }

    public static boolean isTokenCharacter(byte by) {
        return by == 33 || by == 35 || by == 36 || by == 37 || by == 38 || by == 39 || by == 42 || by == 43 || by == 45 || by == 46 || by == 94 || by == 95 || by == 96 || by == 124 || by == 126 || by >= 65 && by <= 90 || by >= 97 && by <= 122 || by >= 48 && by <= 57;
    }

    public static boolean isURICharacter(byte by) {
        return by >= 33 && by <= 126;
    }

    public static boolean isValueCharacter(byte by) {
        int n = by & 0xFF;
        return HTTPTools.isURICharacter(by) || n == 32 || n == 9 || n == 10 || n >= 128;
    }

    public static ParseException makeParseException(byte by, Enum<? extends Enum<?>> enum_) {
        String string = HexFormat.of().withUpperCase().formatHex(new byte[]{by});
        String string2 = HTTPTools.isControlCharacter(by) ? "Unexpected character. Dec [" + by + "] Hex [" + string + "]" : "Unexpected character. Dec [" + by + "] Hex [" + string + "] Symbol [" + (char)by + "]";
        return new ParseException(string2 + " Parse state [" + String.valueOf(enum_) + "]", enum_.name());
    }

    public static void parseEncodedData(byte[] byArray, int n, int n2, Charset charset, Map<String, List<String>> map) {
        String string2;
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        boolean bl = true;
        String string3 = null;
        for (int i = n; i < n2; ++i) {
            if (byArray[i] == 61 && bl) {
                if (i == n) {
                    ++n;
                    continue;
                }
                bl = false;
                try {
                    string3 = URLDecoder.decode(new String(byArray, n, i - n, charset), charset);
                }
                catch (Exception exception) {
                    string3 = null;
                }
                n = i + 1;
                continue;
            }
            if (byArray[i] != 38 || bl) continue;
            bl = true;
            if (string3 == null || n > i) continue;
            try {
                string2 = n < i ? URLDecoder.decode(new String(byArray, n, i - n, charset), charset) : "";
                map.computeIfAbsent(string3, string -> new LinkedList()).add(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            n = i + 1;
            string3 = null;
        }
        if (string3 != null && !bl) {
            try {
                string2 = n < n2 ? URLDecoder.decode(new String(byArray, n, n2 - n, charset), charset) : "";
                map.computeIfAbsent(string3, string -> new LinkedList()).add(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void parseEncodedData(byte[] byArray, int n, int n2, Map<String, List<String>> map) {
        HTTPTools.parseEncodedData(byArray, n, n2, StandardCharsets.UTF_8, map);
    }

    public static HeaderValue parseHeaderValue(String string) {
        String string2 = null;
        Map<String, String> map = null;
        char[] cArray = string.toCharArray();
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (!bl && c == ';') {
                if (string2 == null) {
                    string2 = new String(cArray, n, i - n);
                } else {
                    if (map == null) {
                        map = new HashMap<String, String>();
                    }
                    HTTPTools.parseHeaderParameter(cArray, n, i, map);
                }
                n = -1;
                continue;
            }
            if (!bl && !Character.isWhitespace(c) && n == -1) {
                n = i;
                continue;
            }
            if (!bl && c == '\"') {
                bl = true;
                continue;
            }
            if (bl && c == '\\' && i < cArray.length - 2 && cArray[i + 1] == '\"') {
                ++i;
                continue;
            }
            if (!bl || c != '\"') continue;
            bl = false;
        }
        if (n != -1) {
            if (string2 == null) {
                string2 = new String(cArray, n, cArray.length - n);
            } else {
                if (map == null) {
                    map = new HashMap<String, String>();
                }
                HTTPTools.parseHeaderParameter(cArray, n, cArray.length, map);
            }
        }
        if (map == null) {
            map = Map.of();
        }
        return new HeaderValue(string2, map);
    }

    public static void parseRequestPreamble(PushbackInputStream pushbackInputStream, int n, HTTPRequest hTTPRequest, byte[] byArray, Runnable runnable) throws IOException {
        RequestPreambleState requestPreambleState = RequestPreambleState.RequestMethod;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        String string = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (requestPreambleState != RequestPreambleState.Complete) {
            long l = System.currentTimeMillis();
            n2 = pushbackInputStream.read(byArray);
            if (n2 < 0) {
                long l2 = System.currentTimeMillis() - l;
                throw new ConnectionClosedException(String.format("Read returned [%d] after waiting [%d] ms", n2, l2));
            }
            logger.trace("Read [{}] from client for preamble.", n2);
            if (n4 == 0) {
                runnable.run();
            }
            for (n3 = 0; n3 < n2 && requestPreambleState != RequestPreambleState.Complete; ++n3) {
                byte by = byArray[n3];
                RequestPreambleState requestPreambleState2 = requestPreambleState.next(by);
                if (requestPreambleState2 != requestPreambleState) {
                    switch (requestPreambleState) {
                        case RequestMethod: {
                            hTTPRequest.setMethod(HTTPMethod.of(byteArrayOutputStream.toString(StandardCharsets.UTF_8)));
                            break;
                        }
                        case RequestPath: {
                            hTTPRequest.setPath(byteArrayOutputStream.toString(StandardCharsets.UTF_8));
                            break;
                        }
                        case RequestProtocol: {
                            hTTPRequest.setProtocol(byteArrayOutputStream.toString(StandardCharsets.UTF_8));
                            break;
                        }
                        case HeaderName: {
                            string = byteArrayOutputStream.toString(StandardCharsets.UTF_8);
                            break;
                        }
                        case HeaderValue: {
                            hTTPRequest.addHeader(string, byteArrayOutputStream.toString(StandardCharsets.UTF_8));
                        }
                    }
                    if (requestPreambleState2.store()) {
                        byteArrayOutputStream.reset();
                        byteArrayOutputStream.write(by);
                    }
                } else if (requestPreambleState.store()) {
                    byteArrayOutputStream.write(by);
                }
                requestPreambleState = requestPreambleState2;
            }
            if (n == -1 || (n4 += n3) <= n) continue;
            throw new RequestHeadersTooLargeException((long)n, "The maximum size of the request header has been exceeded. The maximum size is [" + n + "] bytes.");
        }
        if (n3 < n2) {
            pushbackInputStream.push(byArray, n3, n2 - n3);
        }
    }

    public static void writeResponsePreamble(HTTPResponse hTTPResponse, OutputStream outputStream) throws IOException {
        HTTPTools.writeStatusLine(hTTPResponse, outputStream);
        for (Map.Entry<String, List<String>> object : hTTPResponse.getHeadersMap().entrySet()) {
            String string = object.getKey();
            for (String string2 : object.getValue()) {
                outputStream.write(string.getBytes());
                outputStream.write(58);
                outputStream.write(32);
                outputStream.write(string2.getBytes());
                outputStream.write(HTTPValues.ControlBytes.CRLF);
            }
        }
        for (Cookie cookie : hTTPResponse.getCookies()) {
            outputStream.write(HTTPValues.HeaderBytes.SetCookie);
            outputStream.write(58);
            outputStream.write(32);
            outputStream.write(cookie.toResponseHeader().getBytes());
            outputStream.write(HTTPValues.ControlBytes.CRLF);
        }
        outputStream.write(HTTPValues.ControlBytes.CRLF);
    }

    private static void parseHeaderParameter(char[] cArray, int n, int n2, Map<String, String> map) {
        String string;
        boolean bl = false;
        Charset charset = null;
        String string2 = null;
        for (int i = n; i < n2; ++i) {
            if (string2 == null && cArray[i] == '*') {
                bl = true;
                string2 = new String(cArray, n, i - n).toLowerCase();
                n = i + 2;
                continue;
            }
            if (string2 == null && cArray[i] == '=') {
                string2 = new String(cArray, n, i - n).toLowerCase();
                n = i + 1;
                continue;
            }
            if (string2 != null && bl && charset == null && cArray[i] == '\'') {
                string = new String(cArray, n, i - n);
                try {
                    charset = Charset.forName(string);
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    charset = StandardCharsets.UTF_8;
                }
                n = i + 1;
                continue;
            }
            if (string2 == null || !bl || charset == null || cArray[i] != '\'') continue;
            n = i + 1;
        }
        if (n >= n2) {
            if (string2 != null) {
                map.put(string2, "");
            }
            return;
        }
        if (cArray[n] == '\"') {
            ++n;
        }
        if (cArray[n2 - 1] == '\"') {
            --n2;
        }
        String string3 = new String(cArray, n, n2 - n);
        string = URLDecoder.decode(string3, Objects.requireNonNullElse(charset, StandardCharsets.UTF_8));
        if (string2 == null) {
            string2 = string;
            string = "";
        }
        if (!map.containsKey(string2) || bl) {
            map.put(string2, string);
        }
    }

    private static void writeStatusLine(HTTPResponse hTTPResponse, OutputStream outputStream) throws IOException {
        outputStream.write(HTTPValues.ProtocolBytes.HTTTP1_1);
        outputStream.write(32);
        outputStream.write(Integer.toString(hTTPResponse.getStatus()).getBytes());
        outputStream.write(32);
        if (hTTPResponse.getStatusMessage() != null) {
            outputStream.write(hTTPResponse.getStatusMessage().getBytes());
        }
        outputStream.write(HTTPValues.ControlBytes.CRLF);
    }

    public record HeaderValue(String value, Map<String, String> parameters) {
    }
}

