/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server;

import io.fusionauth.http.Cookie;
import io.fusionauth.http.server.io.HTTPOutputStream;
import io.fusionauth.http.util.HTTPTools;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class HTTPResponse {
    private final Map<String, Map<String, Cookie>> cookies = new HashMap<String, Map<String, Cookie>>();
    private final Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
    private Throwable exception;
    private HTTPOutputStream outputStream;
    private int status = 200;
    private String statusMessage;
    private Writer writer;

    public void addCookie(Cookie cookie) {
        String string2 = cookie.path != null ? cookie.path : "/";
        this.cookies.computeIfAbsent(string2, string -> new LinkedHashMap()).put(cookie.name, cookie);
    }

    public void addHeader(String string2, String string3) {
        if (string2 == null || string3 == null) {
            return;
        }
        this.headers.computeIfAbsent(string2.toLowerCase(), string -> new ArrayList()).add(string3);
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        } else {
            this.outputStream.close();
        }
    }

    public boolean containsHeader(String string) {
        String string2 = string.toLowerCase();
        return this.headers.containsKey(string2) && !this.headers.get(string2).isEmpty();
    }

    public boolean failure() {
        return this.status < 200 || this.status > 299;
    }

    public void flush() throws IOException {
        this.outputStream.forceFlush();
    }

    public Charset getCharset() {
        HTTPTools.HeaderValue headerValue;
        String string;
        Charset charset = StandardCharsets.UTF_8;
        String string2 = this.getContentType();
        if (string2 != null && (string = (headerValue = HTTPTools.parseHeaderValue(string2)).parameters().get("charset")) != null) {
            charset = Charset.forName(string);
        }
        return charset;
    }

    public Long getContentLength() {
        if (this.containsHeader("Content-Length")) {
            return Long.parseLong(this.getHeader("Content-Length"));
        }
        return null;
    }

    public void setContentLength(long l) {
        this.setHeader("Content-Length", Long.toString(l));
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public void setContentType(String string) {
        this.setHeader("Content-Type", string);
    }

    public List<Cookie> getCookies() {
        return this.cookies.values().stream().flatMap(map -> map.values().stream()).collect(Collectors.toList());
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable throwable) {
        this.exception = throwable;
    }

    public String getHeader(String string) {
        String string2 = string.toLowerCase();
        return this.headers.containsKey(string2) && !this.headers.get(string2).isEmpty() ? this.headers.get(string2).getFirst() : null;
    }

    public List<String> getHeaders(String string) {
        return this.headers.get(string.toLowerCase());
    }

    public Map<String, List<String>> getHeadersMap() {
        return this.headers;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(HTTPOutputStream hTTPOutputStream) {
        this.outputStream = hTTPOutputStream;
    }

    public String getRedirect() {
        return this.getHeader("Location");
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String string) {
        this.statusMessage = string;
    }

    public Writer getWriter() {
        Charset charset = this.getCharset();
        if (this.writer == null) {
            this.writer = new OutputStreamWriter(this.getOutputStream(), charset);
        }
        return this.writer;
    }

    public boolean isCommitted() {
        return this.outputStream.isCommitted();
    }

    public boolean isCompress() {
        return this.outputStream.isCompress();
    }

    public void setCompress(boolean bl) {
        this.outputStream.setCompress(bl);
    }

    public void removeCookie(String string) {
        this.cookies.values().forEach(map -> map.remove(string));
    }

    public void removeHeader(String string) {
        if (string != null) {
            this.headers.remove(string.toLowerCase());
        }
    }

    public void reset() {
        if (this.outputStream.isCommitted()) {
            throw new IllegalStateException("The HTTPResponse can't be reset after it has been committed, meaning at least one byte was written back to the client.");
        }
        this.cookies.clear();
        this.headers.clear();
        this.exception = null;
        this.outputStream.reset();
        this.status = 200;
        this.statusMessage = null;
        this.writer = null;
    }

    public void sendRedirect(String string) {
        this.setHeader("Location", string);
        this.status = 302;
    }

    public void setDateHeader(String string, ZonedDateTime zonedDateTime) {
        this.addHeader(string, DateTimeFormatter.RFC_1123_DATE_TIME.format(zonedDateTime));
    }

    public void setHeader(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        this.headers.put(string.toLowerCase(), new ArrayList<String>(List.of(string2)));
    }

    public boolean willCompress() {
        return this.outputStream.willCompress();
    }
}

