/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server;

import io.fusionauth.http.BodyException;
import io.fusionauth.http.Buildable;
import io.fusionauth.http.Cookie;
import io.fusionauth.http.FileInfo;
import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.io.MultipartStreamProcessor;
import io.fusionauth.http.util.HTTPTools;
import io.fusionauth.http.util.WeightedString;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class HTTPRequest
implements Buildable<HTTPRequest> {
    private final List<String> acceptEncodings = new LinkedList<String>();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Map<String, Cookie> cookies = new HashMap<String, Cookie>();
    private final List<FileInfo> files = new LinkedList<FileInfo>();
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private final List<Locale> locales = new LinkedList<Locale>();
    private final MultipartStreamProcessor multipartStreamProcessor = new MultipartStreamProcessor();
    private final Map<String, List<String>> urlParameters = new HashMap<String, List<String>>();
    private byte[] bodyBytes;
    private Map<String, List<String>> combinedParameters;
    private Long contentLength;
    private String contentType;
    private String contextPath;
    private Charset encoding = StandardCharsets.UTF_8;
    private Map<String, List<String>> formData;
    private String host;
    private InputStream inputStream;
    private String ipAddress;
    private HTTPMethod method;
    private boolean multipart;
    private String multipartBoundary;
    private String path = "/";
    private int port = -1;
    private String protocol;
    private String queryString;
    private String scheme;

    public HTTPRequest() {
        this.contextPath = "";
    }

    public HTTPRequest(String string, @Deprecated int n, String string2, int n2, String string3) {
        Objects.requireNonNull(string);
        Objects.requireNonNull(string2);
        this.contextPath = string;
        this.scheme = string2;
        this.port = n2;
        this.ipAddress = string3;
        this.multipartStreamProcessor.getMultiPartConfiguration().withMultipartBufferSize(n);
    }

    public HTTPRequest(String string, String string2, int n, String string3) {
        Objects.requireNonNull(string);
        Objects.requireNonNull(string2);
        this.contextPath = string;
        this.scheme = string2;
        this.port = n;
        this.ipAddress = string3;
    }

    public void addAcceptEncoding(String string) {
        this.acceptEncodings.add(string);
    }

    public void addAcceptEncodings(List<String> list) {
        this.acceptEncodings.addAll(list);
    }

    public void addCookies(Cookie ... cookieArray) {
        for (Cookie cookie : cookieArray) {
            this.cookies.put(cookie.name, cookie);
        }
    }

    public void addCookies(Collection<Cookie> collection) {
        if (collection == null) {
            return;
        }
        for (Cookie cookie : collection) {
            this.cookies.put(cookie.name, cookie);
        }
    }

    public void addHeader(String string2, String string3) {
        string2 = string2.toLowerCase();
        this.headers.computeIfAbsent(string2, string -> new ArrayList()).add(string3);
        this.decodeHeader(string2, string3);
    }

    public void addHeaders(String string2, String ... stringArray) {
        string2 = string2.toLowerCase();
        this.headers.computeIfAbsent(string2, string -> new ArrayList()).addAll(List.of(stringArray));
        for (String string3 : stringArray) {
            this.decodeHeader(string2, string3);
        }
    }

    public void addHeaders(String string2, Collection<String> collection) {
        string2 = string2.toLowerCase();
        this.headers.computeIfAbsent(string2, string -> new ArrayList()).addAll(collection);
        for (String string3 : collection) {
            this.decodeHeader(string2, string3);
        }
    }

    public void addHeaders(Map<String, List<String>> map) {
        map.forEach(this::addHeaders);
    }

    public void addLocales(Locale ... localeArray) {
        this.locales.addAll(Arrays.asList(localeArray));
    }

    public void addLocales(Collection<Locale> collection) {
        this.locales.addAll(collection);
    }

    public void addURLParameter(String string2, String string3) {
        this.urlParameters.computeIfAbsent(string2, string -> new ArrayList()).add(string3);
        this.combinedParameters = null;
    }

    public void addURLParameters(String string2, String ... stringArray) {
        this.urlParameters.computeIfAbsent(string2, string -> new ArrayList()).addAll(List.of(stringArray));
        this.combinedParameters = null;
    }

    public void addURLParameters(String string2, Collection<String> collection) {
        this.urlParameters.computeIfAbsent(string2, string -> new ArrayList()).addAll(collection);
        this.combinedParameters = null;
    }

    public void addURLParameters(Map<String, List<String>> map) {
        map.forEach(this::addURLParameters);
        this.combinedParameters = null;
    }

    public void deleteCookie(String string) {
        this.cookies.remove(string);
    }

    public List<String> getAcceptEncodings() {
        return this.acceptEncodings;
    }

    public void setAcceptEncodings(List<String> list) {
        this.acceptEncodings.clear();
        this.acceptEncodings.addAll(list);
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public String getBaseURL() {
        String string = this.getScheme().toLowerCase();
        if (!string.equalsIgnoreCase("http") && !string.equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("The request scheme is invalid. Only http or https are valid schemes. The X-Forwarded-Proto header has a value of [" + this.getHeader("X-Forwarded-Proto") + "], this is likely an issue in your proxy configuration.");
        }
        String string2 = this.getHost().toLowerCase();
        int n = this.getBaseURLServerPort();
        String string3 = string + "://" + string2;
        if (n > 0 && (string.equalsIgnoreCase("http") && n != 80 || string.equalsIgnoreCase("https") && n != 443)) {
            string3 = string3 + ":" + n;
        }
        return string3;
    }

    public byte[] getBodyBytes() throws BodyException {
        if (this.bodyBytes == null) {
            if (this.inputStream != null) {
                try {
                    this.bodyBytes = this.inputStream.readAllBytes();
                }
                catch (IOException iOException) {
                    throw new BodyException("Unable to read the HTTP request body bytes", iOException);
                }
            } else {
                this.bodyBytes = new byte[0];
            }
        }
        return this.bodyBytes;
    }

    public Charset getCharacterEncoding() {
        return this.encoding;
    }

    public void setCharacterEncoding(Charset charset) {
        this.encoding = charset;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(Long l) {
        this.contentLength = l;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String string) {
        this.contextPath = string;
    }

    public Cookie getCookie(String string) {
        return this.cookies.get(string);
    }

    public List<Cookie> getCookies() {
        return new ArrayList<Cookie>(this.cookies.values());
    }

    public Instant getDateHeader(String string) {
        String string2 = this.getHeader(string);
        return string2 != null ? ZonedDateTime.parse(string2, DateTimeFormatter.RFC_1123_DATE_TIME).toInstant() : null;
    }

    public List<FileInfo> getFiles() {
        this.getFormData();
        return this.files;
    }

    public Map<String, List<String>> getFormData() {
        if (this.formData == null) {
            this.formData = new HashMap<String, List<String>>();
            String string = this.getContentType();
            if (string != null && string.equalsIgnoreCase("application/x-www-form-urlencoded")) {
                byte[] byArray = this.getBodyBytes();
                HTTPTools.parseEncodedData(byArray, 0, byArray.length, this.getCharacterEncoding(), this.formData);
            } else if (this.isMultipart()) {
                try {
                    this.multipartStreamProcessor.process(this.inputStream, this.formData, this.files, this.multipartBoundary.getBytes());
                }
                catch (IOException iOException) {
                    throw new BodyException("Invalid multipart body.", iOException);
                }
            }
        }
        return this.formData;
    }

    public String getHeader(String string) {
        List<String> list = this.getHeaders(string);
        return list != null && !list.isEmpty() ? list.getFirst() : null;
    }

    public List<String> getHeaders(String string) {
        return this.headers.get(string.toLowerCase());
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, List<String>> map) {
        this.headers.clear();
        map.forEach(this::setHeaders);
    }

    public String getHost() {
        int n;
        String string = this.getHeader("X-Forwarded-Host");
        if (string == null) {
            return this.host;
        }
        String[] stringArray = string.split(",");
        if (stringArray.length > 1) {
            string = stringArray[0];
        }
        if ((n = string.indexOf(58)) > 0) {
            return string.substring(0, n);
        }
        return string.trim();
    }

    public void setHost(String string) {
        this.host = string;
    }

    public String getIPAddress() {
        String string = this.getHeader("X-Forwarded-For");
        if (string == null || string.trim().length() == 0) {
            return this.ipAddress;
        }
        String[] stringArray = string.split(",");
        if (stringArray.length < 1) {
            return string.trim();
        }
        return stringArray[0].trim();
    }

    public void setIPAddress(String string) {
        this.ipAddress = string;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        this.combinedParameters = null;
        this.formData = null;
    }

    public Locale getLocale() {
        return this.locales.size() > 0 ? this.locales.getFirst() : Locale.getDefault();
    }

    public List<Locale> getLocales() {
        return this.locales;
    }

    public HTTPMethod getMethod() {
        return this.method;
    }

    public void setMethod(HTTPMethod hTTPMethod) {
        this.method = hTTPMethod;
    }

    public MultipartStreamProcessor getMultiPartStreamProcessor() {
        return this.multipartStreamProcessor;
    }

    public String getMultipartBoundary() {
        return this.multipartBoundary;
    }

    public String getParameter(String string) {
        List<String> list = this.getParameters().get(string);
        if (list != null && list.size() > 0) {
            return list.getFirst();
        }
        return null;
    }

    public Map<String, List<String>> getParameters() {
        if (this.combinedParameters == null) {
            this.combinedParameters = new HashMap<String, List<String>>();
            this.getURLParameters().forEach((string, list) -> this.combinedParameters.put((String)string, new LinkedList(list)));
            this.getFormData().forEach((string, list3) -> this.combinedParameters.merge((String)string, (List<String>)list3, (list, list2) -> {
                list.addAll(list2);
                return list;
            }));
        }
        return this.combinedParameters;
    }

    public List<String> getParameters(String string) {
        return this.getParameters().get(string);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.urlParameters.clear();
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        int n = string.indexOf(63);
        if (n > 0 && n != byArray.length - 1) {
            this.queryString = new String(byArray, n + 1, byArray.length - n - 1);
            HTTPTools.parseEncodedData(byArray, n + 1, byArray.length, this.urlParameters);
        }
        this.path = n > 0 ? new String(byArray, 0, n) : string;
    }

    public int getPort() {
        String string = this.getHeader("X-Forwarded-Port");
        return string == null ? this.port : Integer.parseInt(string);
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRawHost() {
        return this.host;
    }

    public String getRawIPAddress() {
        return this.ipAddress;
    }

    public int getRawPort() {
        return this.port;
    }

    public String getRawScheme() {
        return this.scheme;
    }

    public String getScheme() {
        String string = this.getHeader("X-Forwarded-Proto");
        return string == null ? this.scheme : string;
    }

    public void setScheme(String string) {
        this.scheme = string;
    }

    public String getTransferEncoding() {
        return this.getHeader("Transfer-Encoding");
    }

    public String getURLParameter(String string) {
        List<String> list = this.urlParameters.get(string);
        return list != null && list.size() > 0 ? list.getFirst() : null;
    }

    public List<String> getURLParameters(String string) {
        return this.urlParameters.get(string);
    }

    public Map<String, List<String>> getURLParameters() {
        return this.urlParameters;
    }

    public void setURLParameters(Map<String, List<String>> map) {
        this.urlParameters.clear();
        this.urlParameters.putAll(map);
    }

    public boolean hasBody() {
        Long l = this.getContentLength();
        return this.isChunked() || l != null && l > 0L;
    }

    public boolean isChunked() {
        return this.getTransferEncoding() != null && this.getTransferEncoding().equalsIgnoreCase("chunked");
    }

    public boolean isKeepAlive() {
        String string = this.getHeader("Connection");
        if ("HTTP/1.0".equals(this.protocol)) {
            return string != null && string.equalsIgnoreCase("keep-alive");
        }
        return string == null || !string.equalsIgnoreCase("close");
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public Object removeAttribute(String string) {
        return this.attributes.remove(string);
    }

    public void removeHeader(String string) {
        this.headers.remove(string.toLowerCase());
    }

    public void removeHeader(String string, String ... stringArray) {
        List<String> list = this.headers.get(string.toLowerCase());
        if (list != null) {
            list.removeAll(List.of(stringArray));
        }
    }

    public void setAttribute(String string, Object object) {
        this.attributes.put(string, object);
    }

    public void setHeader(String string, String string2) {
        string = string.toLowerCase();
        this.headers.put(string, new ArrayList<String>(List.of(string2)));
        this.decodeHeader(string, string2);
    }

    public void setHeaders(String string, String ... stringArray) {
        string = string.toLowerCase();
        this.headers.put(string, new ArrayList<String>(List.of(stringArray)));
        for (String string2 : stringArray) {
            this.decodeHeader(string, string2);
        }
    }

    public void setHeaders(String string, Collection<String> collection) {
        string = string.toLowerCase();
        this.headers.put(string, new ArrayList<String>(collection));
        for (String string2 : collection) {
            this.decodeHeader(string, string2);
        }
    }

    public void setURLParameter(String string, String string2) {
        this.setURLParameters(string, string2);
    }

    public void setURLParameters(String string, String ... stringArray) {
        this.setURLParameters(string, new ArrayList<String>(List.of(stringArray)));
    }

    public void setURLParameters(String string, Collection<String> collection) {
        ArrayList arrayList = new ArrayList();
        this.urlParameters.put(string, arrayList);
        collection.stream().filter(Objects::nonNull).forEach(arrayList::add);
        this.combinedParameters = null;
    }

    private void decodeHeader(String string, String string2) {
        switch (string) {
            case "accept-encoding": {
                TreeSet<WeightedString> treeSet = new TreeSet<WeightedString>();
                String[] stringArray = string2.split(",");
                int n = 0;
                for (String string3 : stringArray) {
                    if ((string3 = string3.trim()).isEmpty()) continue;
                    HTTPTools.HeaderValue headerValue = HTTPTools.parseHeaderValue(string3);
                    String string4 = headerValue.parameters().get("q");
                    double d = 1.0;
                    if (string4 != null) {
                        d = Double.parseDouble(string4);
                    }
                    WeightedString weightedString = new WeightedString(headerValue.value(), d, n);
                    treeSet.add(weightedString);
                    ++n;
                }
                this.setAcceptEncodings(treeSet.stream().map(WeightedString::value).toList());
                break;
            }
            case "accept-language": {
                try {
                    this.addLocales(Locale.LanguageRange.parse(string2).stream().sorted(Comparator.comparing(Locale.LanguageRange::getWeight).reversed()).map(Locale.LanguageRange::getRange).map(Locale::forLanguageTag).collect(Collectors.toList()));
                }
                catch (Exception exception) {}
                break;
            }
            case "content-type": {
                String string5;
                this.encoding = null;
                this.multipart = false;
                HTTPTools.HeaderValue headerValue = HTTPTools.parseHeaderValue(string2);
                this.contentType = headerValue.value();
                if (headerValue.value().startsWith("multipart/")) {
                    this.multipart = true;
                    this.multipartBoundary = headerValue.parameters().get("boundary");
                }
                if ((string5 = headerValue.parameters().get("charset")) == null) break;
                this.encoding = Charset.forName(string5);
                break;
            }
            case "content-length": {
                if (string2 == null || string2.isBlank()) {
                    this.contentLength = null;
                    break;
                }
                try {
                    this.contentLength = Long.parseLong(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    this.contentLength = null;
                }
                break;
            }
            case "cookie": {
                this.addCookies(Cookie.fromRequestHeader(string2));
                break;
            }
            case "host": {
                int n = string2.indexOf(58);
                if (n > 0) {
                    this.host = string2.substring(0, n);
                    String string6 = string2.substring(n + 1);
                    if (string6.length() <= 0) break;
                    try {
                        this.port = Integer.parseInt(string6);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                this.host = string2;
                if ("http".equalsIgnoreCase(this.scheme)) {
                    this.port = 80;
                    break;
                }
                if (!"https".equalsIgnoreCase(this.scheme)) break;
                this.port = 443;
            }
        }
    }

    private int getBaseURLServerPort() {
        int n = this.getPort();
        if (this.scheme.equalsIgnoreCase("http") && n == 80) {
            n = -1;
        }
        if (this.getHeader("X-Forwarded-Port") != null) {
            return n;
        }
        String string = this.getHeader("X-Forwarded-Host");
        if (string == null) {
            return n;
        }
        try {
            int n2 = URI.create("https://" + string).getPort();
            if (n2 != -1) {
                return n2;
            }
        }
        catch (Exception exception) {
            return n;
        }
        if (!"https".equals(this.getHeader("X-Forwarded-Proto"))) {
            return n;
        }
        return 443;
    }
}

