/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.io;

import io.fusionauth.http.ContentTooLargeException;
import io.fusionauth.http.FileInfo;
import io.fusionauth.http.HTTPValues;
import io.fusionauth.http.ParseException;
import io.fusionauth.http.UnprocessableContentException;
import io.fusionauth.http.io.MultipartConfiguration;
import io.fusionauth.http.io.MultipartFileManager;
import io.fusionauth.http.io.MultipartFileUploadPolicy;
import io.fusionauth.http.util.HTTPTools;
import io.fusionauth.http.util.RequestPreambleState;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MultipartStream {
    private final byte[] boundary;
    private final byte[] buffer;
    private final InputStream input;
    private final MultipartConfiguration multipartConfiguration;
    private final MultipartFileManager multipartFileManager;
    private int boundaryLength;
    private int boundaryStart;
    private long bytesRead;
    private int current;
    private int end;
    private int partialBoundary;

    public MultipartStream(InputStream inputStream, byte[] byArray, MultipartFileManager multipartFileManager, MultipartConfiguration multipartConfiguration) {
        Objects.requireNonNull(inputStream);
        Objects.requireNonNull(byArray);
        Objects.requireNonNull(multipartFileManager);
        Objects.requireNonNull(multipartConfiguration);
        this.multipartFileManager = multipartFileManager;
        this.multipartConfiguration = multipartConfiguration;
        int n = multipartConfiguration.getMultipartBufferSize();
        if (n < byArray.length * 2) {
            throw new IllegalArgumentException("The buffer size specified for the MultipartStream is too small. Must be double the boundary length.");
        }
        this.input = inputStream;
        this.buffer = new byte[n];
        this.boundary = new byte[byArray.length + 4];
        this.boundaryStart = 2;
        this.boundaryLength = byArray.length + 2;
        System.arraycopy(HTTPValues.ControlBytes.MultipartBoundaryPrefix, 0, this.boundary, 0, 4);
        System.arraycopy(byArray, 0, this.boundary, 4, byArray.length);
        this.current = 0;
        this.end = 0;
    }

    public void process(Map<String, List<String>> map, List<FileInfo> list) throws IOException, ParseException {
        if (!this.reload(this.boundaryLength + 2)) {
            throw new ParseException("Invalid multipart body. The body is empty.");
        }
        this.current = this.findBoundary();
        if (this.current == -1) {
            throw new ParseException("Invalid multipart body. The body doesn't contain any boundaries.");
        }
        boolean bl = this.closeBoundary();
        this.boundaryStart = 0;
        this.boundaryLength = this.boundary.length;
        HashMap<String, HTTPTools.HeaderValue> hashMap = new HashMap<String, HTTPTools.HeaderValue>();
        while (bl) {
            this.readHeaders(hashMap);
            this.readPart(hashMap, map, list);
            bl = this.closeBoundary();
            if (!bl) continue;
            hashMap.clear();
        }
    }

    private boolean closeBoundary() throws IOException {
        boolean bl;
        this.current += this.boundaryLength;
        byte by = this.readByte();
        byte by2 = this.readByte();
        if (by == 45 && by2 == 45) {
            bl = false;
        } else if (by == 13 && by2 == 10) {
            bl = true;
        } else {
            throw new ParseException("Unexpected characters [" + new String(new byte[]{by, by2}) + "] follow a boundary.");
        }
        return bl;
    }

    private int findBoundary() {
        int n = this.boundaryStart;
        for (int i = this.current; i < this.end; ++i) {
            int n2;
            while (i < this.end && this.buffer[i] != this.boundary[n]) {
                ++i;
            }
            this.partialBoundary = i < this.end ? i : -1;
            for (n2 = i; n2 < this.end && n < this.boundaryLength && this.buffer[n2] == this.boundary[n]; ++n2, ++n) {
            }
            if (n == this.boundaryLength) {
                this.partialBoundary = -1;
                return i;
            }
            if (n2 == this.end) {
                return -1;
            }
            n = 0;
            this.partialBoundary = -1;
        }
        return -1;
    }

    private byte readByte() throws IOException {
        if (this.current == this.end && !this.reload(1)) {
            throw new ParseException("Invalid multipart body. Ran out of data while processing.");
        }
        return this.buffer[this.current++];
    }

    private void readHeaders(Map<String, HTTPTools.HeaderValue> map) throws IOException, ParseException {
        RequestPreambleState requestPreambleState = RequestPreambleState.HeaderName;
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        while (requestPreambleState != RequestPreambleState.Complete) {
            byte by = this.readByte();
            RequestPreambleState requestPreambleState2 = requestPreambleState.next(by);
            if (requestPreambleState2 != requestPreambleState) {
                switch (requestPreambleState) {
                    case HeaderName: {
                        string = stringBuilder.toString().toLowerCase();
                        break;
                    }
                    case HeaderValue: {
                        map.put(string, HTTPTools.parseHeaderValue(stringBuilder.toString()));
                    }
                }
                if (requestPreambleState2.store()) {
                    stringBuilder.delete(0, stringBuilder.length());
                    stringBuilder.appendCodePoint(by);
                }
            } else if (requestPreambleState.store()) {
                stringBuilder.appendCodePoint(by);
            }
            requestPreambleState = requestPreambleState2;
        }
    }

    private void readPart(Map<String, HTTPTools.HeaderValue> map, Map<String, List<String>> map2, List<FileInfo> list) throws IOException, ParseException {
        PartProcessor partProcessor;
        ParameterPartProcessor parameterPartProcessor;
        Charset charset;
        HTTPTools.HeaderValue headerValue = map.get("content-disposition");
        if (headerValue == null) {
            throw new ParseException("Invalid multipart body. A part is missing a [Content-Disposition] header.");
        }
        String string2 = headerValue.parameters().get("name");
        if (string2 == null) {
            throw new ParseException("Invalid multipart body. A part is missing a name parameter in the [Content-Disposition] header.");
        }
        String string3 = headerValue.parameters().get("filename");
        boolean bl = string3 != null;
        HTTPTools.HeaderValue headerValue2 = map.get("content-type");
        String string4 = headerValue2 != null ? headerValue2.value() : "application/octet-stream";
        String string5 = headerValue2 != null ? headerValue2.parameters().get("charset") : null;
        Charset charset2 = charset = string5 != null ? Charset.forName(string5) : StandardCharsets.UTF_8;
        if (bl) {
            if (this.multipartConfiguration.getFileUploadPolicy() == MultipartFileUploadPolicy.Reject) {
                throw new UnprocessableContentException("The multipart stream cannot be processed. Multipart processing of files has been disabled.");
            }
            parameterPartProcessor = this.multipartConfiguration.getFileUploadPolicy() == MultipartFileUploadPolicy.Allow ? this.multipartFileManager.createTemporaryFile() : null;
            partProcessor = new FilePartProcessor(string4, charset, string3, string2, this.multipartConfiguration.getMaxFileSize(), (Path)((Object)parameterPartProcessor));
        } else {
            partProcessor = new ParameterPartProcessor(charset);
        }
        parameterPartProcessor = partProcessor;
        try {
            int n;
            do {
                if ((n = this.findBoundary()) == -1) {
                    if (this.partialBoundary == -1) {
                        partProcessor.process(this.current, this.end);
                    } else {
                        partProcessor.process(this.current, this.partialBoundary);
                    }
                    if (this.reload(this.boundary.length + 2)) continue;
                    throw new ParseException("Invalid multipart body. Ran out of data while processing.");
                }
                partProcessor.process(this.current, n);
                this.current = n;
            } while (n == -1);
            if (bl) {
                if (this.multipartConfiguration.getFileUploadPolicy() == MultipartFileUploadPolicy.Allow) {
                    list.add(partProcessor.toFileInfo());
                }
            } else {
                map2.computeIfAbsent(string2, string -> new LinkedList()).add(partProcessor.toValue());
            }
        }
        finally {
            if (parameterPartProcessor != null) {
                parameterPartProcessor.close();
            }
        }
    }

    private boolean reload(int n) throws IOException {
        int n2 = 0;
        if (this.partialBoundary > 0) {
            System.arraycopy(this.buffer, this.partialBoundary, this.buffer, 0, this.end - this.partialBoundary);
            n2 = this.end - this.partialBoundary;
            this.end -= this.partialBoundary;
            this.partialBoundary = -1;
            n = this.boundaryLength + 2;
        } else {
            this.end = 0;
        }
        this.current = 0;
        while (this.end < n) {
            int n3 = this.input.read(this.buffer, n2, this.buffer.length - n2);
            if (n3 == -1) {
                return false;
            }
            this.end += n3;
            n2 += this.end;
            this.bytesRead += (long)n3;
            long l = this.multipartConfiguration.getMaxRequestSize();
            if (this.bytesRead <= l) continue;
            String string = "The maximum request size of multipart stream has been exceeded. The maximum request size is [" + l + "] bytes.";
            throw new ContentTooLargeException(l, string);
        }
        return true;
    }

    private class FilePartProcessor
    implements PartProcessor {
        private final String contentType;
        private final Charset encoding;
        private final String filename;
        private final long maxFileSize;
        private final String name;
        private final OutputStream output;
        private final Path path;
        private long bytesWritten;

        private FilePartProcessor(String string, Charset charset, String string2, String string3, long l, Path path) throws IOException {
            this.contentType = string;
            this.encoding = charset;
            this.filename = string2;
            this.name = string3;
            this.maxFileSize = l;
            this.path = path;
            this.output = this.path != null ? Files.newOutputStream(this.path, new OpenOption[0]) : OutputStream.nullOutputStream();
        }

        @Override
        public void close() throws IOException {
            this.output.close();
        }

        @Override
        public void process(int n, int n2) throws IOException {
            int n3 = n2 - n;
            this.bytesWritten += (long)n3;
            if (this.bytesWritten > this.maxFileSize) {
                String string = "The maximum size of a single file in a multipart stream has been exceeded. The maximum file size is [" + this.maxFileSize + "] bytes.";
                throw new ContentTooLargeException(this.maxFileSize, string);
            }
            this.output.write(MultipartStream.this.buffer, n, n2 - n);
        }

        @Override
        public FileInfo toFileInfo() throws IOException {
            this.output.close();
            return new FileInfo(this.path, this.filename, this.name, this.contentType, this.encoding);
        }

        @Override
        public String toValue() {
            throw new UnsupportedOperationException();
        }
    }

    private class ParameterPartProcessor
    implements PartProcessor {
        private final Charset encoding;
        private final ByteArrayOutputStream output = new ByteArrayOutputStream();

        private ParameterPartProcessor(Charset charset) {
            this.encoding = charset;
        }

        @Override
        public void close() {
        }

        @Override
        public void process(int n, int n2) {
            if (n < n2) {
                this.output.write(MultipartStream.this.buffer, n, n2 - n);
            }
        }

        @Override
        public FileInfo toFileInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toValue() {
            return this.output.toString(this.encoding);
        }
    }

    private static interface PartProcessor
    extends Closeable {
        public void process(int var1, int var2) throws IOException;

        public FileInfo toFileInfo() throws IOException;

        public String toValue();
    }
}

