/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class HTTPMethod {
    public static final HTTPMethod CONNECT = new HTTPMethod("CONNECT");
    public static final HTTPMethod DELETE = new HTTPMethod("DELETE");
    public static final HTTPMethod GET = new HTTPMethod("GET");
    public static final HTTPMethod HEAD = new HTTPMethod("HEAD");
    public static final HTTPMethod OPTIONS = new HTTPMethod("OPTIONS");
    public static final HTTPMethod PATCH = new HTTPMethod("PATCH");
    public static final HTTPMethod POST = new HTTPMethod("POST");
    public static final HTTPMethod PUT = new HTTPMethod("PUT");
    public static final HTTPMethod TRACE = new HTTPMethod("TRACE");
    public static Map<String, HTTPMethod> StandardMethods = new HashMap<String, HTTPMethod>();
    private final String name;

    private HTTPMethod(String string) {
        Objects.requireNonNull(string);
        this.name = string.toUpperCase(Locale.ROOT);
    }

    public static HTTPMethod of(String string) {
        HTTPMethod hTTPMethod = StandardMethods.get(string = string.toUpperCase(Locale.ROOT));
        if (hTTPMethod == null) {
            hTTPMethod = new HTTPMethod(string);
        }
        return hTTPMethod;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HTTPMethod)) {
            return false;
        }
        HTTPMethod hTTPMethod = (HTTPMethod)object;
        return Objects.equals(this.name, hTTPMethod.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean is(HTTPMethod hTTPMethod) {
        return this == hTTPMethod || this.equals(hTTPMethod);
    }

    public boolean is(String string) {
        return this.name.equals(string);
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    static {
        StandardMethods.put(CONNECT.name(), CONNECT);
        StandardMethods.put(DELETE.name(), DELETE);
        StandardMethods.put(GET.name(), GET);
        StandardMethods.put(HEAD.name(), HEAD);
        StandardMethods.put(OPTIONS.name(), OPTIONS);
        StandardMethods.put(PATCH.name(), PATCH);
        StandardMethods.put(POST.name(), POST);
        StandardMethods.put(PUT.name(), PUT);
        StandardMethods.put(TRACE.name(), TRACE);
    }
}

