/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.samlv2.domain;

import io.fusionauth.samlv2.domain.Assertion;
import io.fusionauth.samlv2.domain.SAMLResponse;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AuthenticationResponse
extends SAMLResponse {
    public List<Assertion> assertions = new ArrayList<Assertion>();
    public String rawResponse;
    public ZonedDateTime sessionExpiry;
    public String sessionIndex;

    public AuthenticationResponse() {
    }

    public AuthenticationResponse(AuthenticationResponse authenticationResponse) {
        super(authenticationResponse);
        this.assertions.addAll(authenticationResponse.assertions.stream().map(Assertion::new).toList());
        this.rawResponse = authenticationResponse.rawResponse;
        this.sessionExpiry = authenticationResponse.sessionExpiry;
        this.sessionIndex = authenticationResponse.sessionIndex;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        AuthenticationResponse authenticationResponse = (AuthenticationResponse)object;
        return Objects.equals(this.assertions, authenticationResponse.assertions) && Objects.equals(this.sessionExpiry, authenticationResponse.sessionExpiry) && Objects.equals(this.sessionIndex, authenticationResponse.sessionIndex);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.assertions, this.rawResponse, this.sessionExpiry, this.sessionIndex);
    }
}

