/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.der;

import io.fusionauth.der.TagClass;
import java.util.Objects;

public class Tag {
    public static final int BitString = 3;
    public static final int Integer = 2;
    public static final int Null = 5;
    public static final int ObjectIdentifier = 6;
    public static final int OctetString = 4;
    public static final int PrintableString = 19;
    public static final int Sequence = 48;
    public static final int Set = 17;
    public static final int UTCTime = 23;
    public final boolean primitive;
    public final byte rawByte;
    public final TagClass tagClass;
    public final int value;

    public Tag(int n) {
        this.rawByte = (byte)n;
        this.tagClass = this.setTagClass(n);
        this.primitive = (this.rawByte & 0x20) == 0;
        this.value = n & 0x1F;
    }

    static String hexString(int n) {
        return "0x" + String.format("%02x", n).toUpperCase();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Tag)) {
            return false;
        }
        Tag tag = (Tag)object;
        return this.rawByte == tag.rawByte;
    }

    public String getName() {
        switch (this.rawByte) {
            case 2: {
                return "Integer";
            }
            case 3: {
                return "Bit String";
            }
            case 5: {
                return "Null";
            }
            case 6: {
                return "Object Identifier";
            }
            case 4: {
                return "Octet String";
            }
            case 19: {
                return "PrintableString";
            }
            case 48: {
                return "Sequence";
            }
            case 17: {
                return "Set";
            }
            case 23: {
                return "UTCTime";
            }
        }
        return "Other";
    }

    public int hashCode() {
        return Objects.hash(this.rawByte);
    }

    public boolean is(int n) {
        return this.value == (n & 0x1F);
    }

    public boolean isConstructed() {
        return !this.primitive;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public String toString() {
        if (this.tagClass == TagClass.ContextSpecific) {
            return "[" + this.value + "]";
        }
        return this.value + " [" + this.getName() + ", " + this.hexString() + "]";
    }

    private TagClass setTagClass(int n) {
        TagClass tagClass = null;
        for (TagClass tagClass2 : TagClass.values()) {
            if ((n & 0xC0) != tagClass2.value) continue;
            tagClass = tagClass2;
            break;
        }
        if (tagClass == null) {
            throw new IllegalArgumentException("Invalid tag value " + n + ", the tag does not appear to fit into one of the expected classes");
        }
        return tagClass;
    }

    String hexString() {
        return "0x" + String.format("%02x", this.value).toUpperCase();
    }
}

