/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.samlv2.domain;

public enum Algorithm {
    ES1("SHA1withECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1"),
    ES256("SHA256withECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256"),
    ES384("SHA384withECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384"),
    ES512("SHA512withECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512"),
    RS1("SHA1withRSA", "http://www.w3.org/2000/09/xmldsig#rsa-sha1"),
    RS256("SHA256withRSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"),
    RS384("SHA384withRSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384"),
    RS512("SHA512withRSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512");

    public final String name;
    public final String uri;

    private Algorithm(String string2, String string3) {
        this.name = string2;
        this.uri = string3;
    }

    public static Algorithm fromURI(String string) {
        for (Algorithm algorithm : Algorithm.values()) {
            if (!algorithm.uri.equals(string)) continue;
            return algorithm;
        }
        return null;
    }
}

