/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.der;

import io.fusionauth.der.DerDecodingException;
import io.fusionauth.der.DerValue;
import io.fusionauth.der.ObjectIdentifier;
import io.fusionauth.der.Tag;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public class DerInputStream {
    public ByteArrayInputStream data;
    public int length;

    public DerInputStream(DerValue derValue) {
        this(derValue.toByteArray());
    }

    public DerInputStream(byte[] byArray) {
        this.data = new ByteArrayInputStream(byArray);
        this.length = byArray.length;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DerInputStream)) {
            return false;
        }
        DerInputStream derInputStream = (DerInputStream)object;
        return this.length == derInputStream.length && Arrays.equals(this.toByteArray(), derInputStream.toByteArray());
    }

    public ObjectIdentifier getOID() throws DerDecodingException {
        int n = this.data.read();
        if (n != 6) {
            throw new DerDecodingException("Expected to find an Object Identifier tag 6 (" + Tag.hexString(6) + ") but found " + n + " (" + Tag.hexString(n) + ")");
        }
        int n2 = this.readLength();
        if (n2 > this.data.available()) {
            throw new DerDecodingException("A DER encoded value indicates it is [" + n2 + "] bytes long, but only [" + this.data.available() + "] are available to read in the input stream length. Unable to read the Object Identifier from the stream.");
        }
        byte[] byArray = new byte[n2];
        this.data.read(byArray, 0, n2);
        return new ObjectIdentifier(byArray);
    }

    public DerValue[] getSequence() throws DerDecodingException {
        int n = this.data.read();
        if (n != 48) {
            throw new DerDecodingException("Expected to find a sequence tag 48 (" + Tag.hexString(48) + ") but found " + n + " (" + Tag.hexString(n) + ")");
        }
        int n2 = this.readLength();
        byte[] byArray = this.copyBytes(n2);
        return this.getValuesFromBytes(byArray);
    }

    public int hashCode() {
        return Objects.hash(this.toByteArray(), this.length);
    }

    public DerValue readDerValue() throws DerDecodingException {
        int n = this.data.read();
        int n2 = this.readLength();
        byte[] byArray = this.copyBytes(n2);
        return new DerValue(n, byArray);
    }

    public byte[] toByteArray() {
        try {
            byte[] byArray = new byte[this.length];
            this.data.reset();
            int n = this.data.read(byArray);
            if (n != this.length) {
                throw new IOException("Failed to read the entire byte array. Expected to read " + this.length + " bytes, but only read " + n + ".");
            }
            return byArray;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private byte[] copyBytes(int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)this.data.read();
        }
        return byArray;
    }

    private DerValue[] getValuesFromBytes(byte[] byArray) throws DerDecodingException {
        ArrayList<DerValue> arrayList = new ArrayList<DerValue>();
        int n = 0;
        while (n < byArray.length) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, byArray.length);
            int n2 = byteArrayInputStream.available();
            Tag tag = new Tag(byteArrayInputStream.read());
            int n3 = this.readLength(byteArrayInputStream);
            int n4 = Math.abs(byteArrayInputStream.available() - n2);
            byte[] byArray2 = new byte[n3];
            for (int i = 0; i < n3; ++i) {
                byArray2[i] = (byte)byteArrayInputStream.read();
            }
            arrayList.add(new DerValue(tag, byArray2));
            n = n + n3 + n4;
        }
        return arrayList.toArray(new DerValue[0]);
    }

    private int readLength(InputStream inputStream) throws DerDecodingException {
        try {
            int n = inputStream.read();
            if (n == -1) {
                throw new IOException("Invalid DER encoding, unable to read length of -1.");
            }
            int n2 = n;
            int n3 = n2 & 0x80;
            if (n3 == 0) {
                return n2;
            }
            n3 = n2 & 0x7F;
            if (n3 == 0) {
                return -1;
            }
            if (n3 < 0) {
                throw new IOException("Invalid DER encoding.");
            }
            if (n3 > 4) {
                throw new IOException("Invalid DER encoding, the value is too big.");
            }
            n2 = inputStream.read() & 0xFF;
            --n3;
            if (n2 == 0) {
                throw new IOException("Redundant length bytes found");
            }
            while (n3 > 0) {
                --n3;
                n2 <<= 8;
                n2 += inputStream.read() & 0xFF;
            }
            if (n2 < 0) {
                throw new IOException("Invalid length bytes");
            }
            if (n2 <= 127) {
                throw new IOException("Should use short form for length");
            }
            return n2;
        }
        catch (IOException iOException) {
            throw new DerDecodingException(iOException);
        }
    }

    private int readLength() throws DerDecodingException {
        return this.readLength(this.data);
    }
}

