/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.samlv2.domain;

public enum NameIDFormat {
    EmailAddress("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress"),
    Entity("urn:oasis:names:tc:SAML:2.0:nameid-format:entity"),
    Kerberos("urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos"),
    Transient("urn:oasis:names:tc:SAML:2.0:nameid-format:transient"),
    Persistent("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent"),
    Unspecified("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"),
    WindowsDomain("urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName"),
    X509("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");

    private final String samlFormat;

    private NameIDFormat(String string2) {
        this.samlFormat = string2;
    }

    public static NameIDFormat fromSAMLFormat(String string) {
        if (string == null) {
            return null;
        }
        for (NameIDFormat nameIDFormat : NameIDFormat.values()) {
            if (!nameIDFormat.toSAMLFormat().equals(string)) continue;
            return nameIDFormat;
        }
        if (string.toLowerCase().contains("email")) {
            return EmailAddress;
        }
        throw new IllegalArgumentException("Invalid SAML v2.0 Name ID format [" + string + "]");
    }

    public String toSAMLFormat() {
        return this.samlFormat;
    }
}

