/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.samlv2.domain;

public enum DigestAlgorithm {
    SHA1("SHA1", "http://www.w3.org/2000/09/xmldsig#sha1", "SHA-1"),
    SHA256("SHA256", "http://www.w3.org/2001/04/xmlenc#sha256", "SHA-256"),
    SHA384("SHA384", "http://www.w3.org/2001/04/xmlenc#sha384", "SHA-384"),
    SHA512("SHA512", "http://www.w3.org/2001/04/xmlenc#sha512", "SHA-512");

    public final String digest;
    public final String name;
    public final String uri;

    private DigestAlgorithm(String string2, String string3, String string4) {
        this.name = string2;
        this.uri = string3;
        this.digest = string4;
    }

    public static DigestAlgorithm fromURI(String string) {
        for (DigestAlgorithm digestAlgorithm : DigestAlgorithm.values()) {
            if (!digestAlgorithm.uri.equals(string)) continue;
            return digestAlgorithm;
        }
        return null;
    }
}

