/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.der;

import io.fusionauth.der.DerEncodingException;
import io.fusionauth.der.DerValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DerOutputStream {
    private final ByteArrayOutputStream os = new ByteArrayOutputStream();

    public byte[] toByteArray() {
        return this.os.toByteArray();
    }

    public DerOutputStream writeValue(DerValue derValue) throws DerEncodingException {
        try {
            this.os.write(derValue.tag.rawByte);
            this.writeLength(derValue.getLength());
            this.os.write(derValue.toByteArray());
            return this;
        }
        catch (IOException iOException) {
            throw new DerEncodingException(iOException);
        }
    }

    private void writeLength(int n) {
        if (n < 128) {
            this.os.write((byte)n);
        } else if (n < 256) {
            this.os.write(-127);
            this.os.write((byte)n);
        } else if (n < 65536) {
            this.os.write(-126);
            this.os.write((byte)(n >> 8));
            this.os.write((byte)n);
        } else if (n < 0x1000000) {
            this.os.write(-125);
            this.os.write((byte)(n >> 16));
            this.os.write((byte)(n >> 8));
            this.os.write((byte)n);
        } else {
            this.os.write(-124);
            this.os.write((byte)(n >> 24));
            this.os.write((byte)(n >> 16));
            this.os.write((byte)(n >> 8));
            this.os.write((byte)n);
        }
    }
}

