/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.load;

import com.inversoft.rest.ClientResponse;
import io.fusionauth.client.FusionAuthClient;
import io.fusionauth.domain.api.LoginRequest;
import io.fusionauth.load.Configuration;
import io.fusionauth.load.FusionAuthBaseWorker;
import java.util.Random;
import java.util.UUID;

public class FusionAuthLoginWorker
extends FusionAuthBaseWorker {
    private final UUID configuredApplicationId;
    private final int loginLowerBound;
    private final int loginUpperBound;

    public FusionAuthLoginWorker(FusionAuthClient client, Configuration configuration) {
        super(client, configuration);
        this.configuredApplicationId = configuration.hasProperty("applicationId") ? UUID.fromString(configuration.getString("applicationId")) : null;
        this.loginLowerBound = configuration.getInteger("loginLowerBound", 0);
        this.loginUpperBound = configuration.getInteger("loginUpperBound", 1000000);
    }

    @Override
    public boolean execute() {
        int index = new Random().nextInt(this.loginUpperBound - this.loginLowerBound + 1) + this.loginLowerBound;
        this.setUserIndex(index);
        String email = "load_user_" + this.userIndex + "@fusionauth.io";
        UUID registrationAppId = this.configuredApplicationId != null ? this.configuredApplicationId : this.applicationId;
        ClientResponse result = this.tenantScopedClient.login(new LoginRequest(registrationAppId, email, "11e7ea7b-784d-4687-bf2d-4f8ee479a4dd11e7ea7b-784d-4687-bf2d-4f8ee479a4dd"));
        if (result.wasSuccessful()) {
            return true;
        }
        this.printErrors(result);
        return false;
    }
}

